/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol;

import aima.logic.fol.Connectors;
import aima.logic.fol.Quantifiers;
import aima.logic.fol.parsing.FOLVisitor;
import aima.logic.fol.parsing.ast.ConnectedSentence;
import aima.logic.fol.parsing.ast.Constant;
import aima.logic.fol.parsing.ast.Function;
import aima.logic.fol.parsing.ast.NotSentence;
import aima.logic.fol.parsing.ast.Predicate;
import aima.logic.fol.parsing.ast.QuantifiedSentence;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.TermEquality;
import aima.logic.fol.parsing.ast.Variable;

class NegationsIn
implements FOLVisitor {
    @Override
    public Object visitPredicate(Predicate p, Object arg) {
        return p;
    }

    @Override
    public Object visitTermEquality(TermEquality equality, Object arg) {
        return equality;
    }

    @Override
    public Object visitVariable(Variable variable, Object arg) {
        return variable;
    }

    @Override
    public Object visitConstant(Constant constant, Object arg) {
        return constant;
    }

    @Override
    public Object visitFunction(Function function, Object arg) {
        return function;
    }

    @Override
    public Object visitNotSentence(NotSentence notSentence, Object arg) {
        Sentence negated = notSentence.getNegated();
        if (negated instanceof NotSentence) {
            return ((NotSentence)negated).getNegated().accept(this, arg);
        }
        if (negated instanceof ConnectedSentence) {
            ConnectedSentence negConnected = (ConnectedSentence)negated;
            Sentence alpha = negConnected.getFirst();
            Sentence beta = negConnected.getSecond();
            if (Connectors.isAND(negConnected.getConnector())) {
                Sentence notAlpha = (Sentence)new NotSentence(alpha).accept(this, arg);
                Sentence notBeta = (Sentence)new NotSentence(beta).accept(this, arg);
                return new ConnectedSentence("OR", notAlpha, notBeta);
            }
            if (Connectors.isOR(negConnected.getConnector())) {
                Sentence notAlpha = (Sentence)new NotSentence(alpha).accept(this, arg);
                Sentence notBeta = (Sentence)new NotSentence(beta).accept(this, arg);
                return new ConnectedSentence("AND", notAlpha, notBeta);
            }
        }
        if (negated instanceof QuantifiedSentence) {
            QuantifiedSentence negQuantified = (QuantifiedSentence)negated;
            Sentence notP = (Sentence)new NotSentence(negQuantified.getQuantified()).accept(this, arg);
            if (Quantifiers.isFORALL(negQuantified.getQuantifier())) {
                return new QuantifiedSentence("EXISTS", negQuantified.getVariables(), notP);
            }
            if (Quantifiers.isEXISTS(negQuantified.getQuantifier())) {
                return new QuantifiedSentence("FORALL", negQuantified.getVariables(), notP);
            }
        }
        return new NotSentence((Sentence)negated.accept(this, arg));
    }

    @Override
    public Object visitConnectedSentence(ConnectedSentence sentence, Object arg) {
        return new ConnectedSentence(sentence.getConnector(), (Sentence)sentence.getFirst().accept(this, arg), (Sentence)sentence.getSecond().accept(this, arg));
    }

    @Override
    public Object visitQuantifiedSentence(QuantifiedSentence sentence, Object arg) {
        return new QuantifiedSentence(sentence.getQuantifier(), sentence.getVariables(), (Sentence)sentence.getQuantified().accept(this, arg));
    }
}

