/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.demos;

import aima.learning.framework.DataSet;
import aima.learning.framework.DataSetFactory;
import aima.learning.framework.Learner;
import aima.learning.inductive.DLTestFactory;
import aima.learning.inductive.DecisionTree;
import aima.learning.learners.AdaBoostLearner;
import aima.learning.learners.DecisionListLearner;
import aima.learning.learners.DecisionTreeLearner;
import aima.learning.learners.StumpLearner;
import aima.learning.neural.BackPropLearning;
import aima.learning.neural.FeedForwardNeuralNetwork;
import aima.learning.neural.IrisDataSetNumerizer;
import aima.learning.neural.IrisNNDataSet;
import aima.learning.neural.NNConfig;
import aima.learning.neural.Perceptron;
import aima.util.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LearningDemo {
    public static void main(String[] args) {
        LearningDemo.decisionTreeDemo();
        LearningDemo.decisionListDemo();
        LearningDemo.ensembleLearningDemo();
        LearningDemo.perceptronDemo();
        LearningDemo.backPropogationDemo();
    }

    private static void decisionTreeDemo() {
        System.out.println(Util.ntimes("*", 100));
        System.out.println("\nDecisionTree Demo - Inducing a DecisionList from the Restaurant DataSet\n ");
        System.out.println(Util.ntimes("*", 100));
        try {
            DataSet ds = DataSetFactory.getRestaurantDataSet();
            DecisionTreeLearner learner = new DecisionTreeLearner();
            learner.train(ds);
            System.out.println("The Induced Decision Tree is ");
            System.out.println(learner.getDecisionTree());
            int[] result = learner.test(ds);
            System.out.println("\nThis Decision Tree classifies the data set with " + result[0] + " successes and " + result[1] + " failures");
            System.out.println("\n");
        }
        catch (Exception e) {
            System.out.println("Decision Tree Demo Failed  ");
            e.printStackTrace();
        }
    }

    private static void decisionListDemo() {
        try {
            System.out.println(Util.ntimes("*", 100));
            System.out.println("DecisionList Demo - Inducing a DecisionList from the Restaurant DataSet\n ");
            System.out.println(Util.ntimes("*", 100));
            DataSet ds = DataSetFactory.getRestaurantDataSet();
            DecisionListLearner learner = new DecisionListLearner("Yes", "No", new DLTestFactory());
            learner.train(ds);
            System.out.println("The Induced DecisionList is");
            System.out.println(learner.getDecisionList());
            int[] result = learner.test(ds);
            System.out.println("\nThis Decision List classifies the data set with " + result[0] + " successes and " + result[1] + " failures");
            System.out.println("\n");
        }
        catch (Exception e) {
            System.out.println("Decision ListDemo Failed");
        }
    }

    private static void ensembleLearningDemo() {
        System.out.println(Util.ntimes("*", 100));
        System.out.println("\n Ensemble Decision Demo - Weak Learners co operating to give Superior decisions ");
        System.out.println(Util.ntimes("*", 100));
        try {
            DataSet ds = DataSetFactory.getRestaurantDataSet();
            List<DecisionTree> stumps = DecisionTree.getStumpsFor(ds, "Yes", "No");
            ArrayList<Learner> learners = new ArrayList<Learner>();
            System.out.println("\nStump Learners vote to decide in this algorithm");
            Iterator<DecisionTree> iterator = stumps.iterator();
            while (iterator.hasNext()) {
                DecisionTree stump;
                DecisionTree sl = stump = iterator.next();
                StumpLearner stumpLearner = new StumpLearner(sl, "No");
                learners.add(stumpLearner);
            }
            AdaBoostLearner learner = new AdaBoostLearner(learners, ds);
            learner.train(ds);
            int[] result = learner.test(ds);
            System.out.println("\nThis Ensemble Learner  classifies the data set with " + result[0] + " successes and " + result[1] + " failures");
            System.out.println("\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void perceptronDemo() {
        try {
            System.out.println(Util.ntimes("*", 100));
            System.out.println("\n Perceptron Demo - Running Perceptron on Iris data Set with 10 epochs of learning ");
            System.out.println(Util.ntimes("*", 100));
            DataSet irisDataSet = DataSetFactory.getIrisDataSet();
            IrisDataSetNumerizer numerizer = new IrisDataSetNumerizer();
            IrisNNDataSet innds = new IrisNNDataSet();
            innds.createExamplesFromDataSet(irisDataSet, numerizer);
            Perceptron perc = new Perceptron(3, 4);
            perc.trainOn(innds, 10);
            innds.refreshDataset();
            int[] result = perc.testOnDataSet(innds);
            System.out.println(result[0] + " right, " + result[1] + " wrong");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void backPropogationDemo() {
        try {
            System.out.println(Util.ntimes("*", 100));
            System.out.println("\n BackpropagationDemo  - Running BackProp on Iris data Set with 10 epochs of learning ");
            System.out.println(Util.ntimes("*", 100));
            DataSet irisDataSet = DataSetFactory.getIrisDataSet();
            IrisDataSetNumerizer numerizer = new IrisDataSetNumerizer();
            IrisNNDataSet innds = new IrisNNDataSet();
            innds.createExamplesFromDataSet(irisDataSet, numerizer);
            NNConfig config = new NNConfig();
            config.setConfig("number_of_inputs", 4);
            config.setConfig("number_of_outputs", 3);
            config.setConfig("number_of_hidden_neurons", 6);
            config.setConfig("lower_limit_weights", -2.0);
            config.setConfig("upper_limit_weights", 2.0);
            FeedForwardNeuralNetwork ffnn = new FeedForwardNeuralNetwork(config);
            ffnn.setTrainingScheme(new BackPropLearning(0.1, 0.9));
            ffnn.trainOn(innds, 10);
            innds.refreshDataset();
            int[] result = ffnn.testOnDataSet(innds);
            System.out.println(result[0] + " right, " + result[1] + " wrong");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

