/*
 * Decompiled with CFR 0.152.
 */
package aima.basic;

import aima.basic.Agent;
import aima.basic.BasicEnvironmentView;
import aima.basic.EnvironmentObject;
import aima.basic.ObjectWithDynamicAttributes;
import aima.basic.Percept;
import java.util.ArrayList;
import java.util.List;

public abstract class Environment {
    protected ArrayList<EnvironmentObject> objects;
    protected ArrayList<Agent> agents = new ArrayList();
    protected ArrayList<BasicEnvironmentView> views;

    public abstract void executeAction(Agent var1, String var2);

    public abstract Percept getPerceptSeenBy(Agent var1);

    protected Environment() {
        this.objects = new ArrayList();
        this.views = new ArrayList();
    }

    public void registerView(BasicEnvironmentView bev) {
        this.views.add(bev);
    }

    public void updateViews(String command) {
        for (BasicEnvironmentView view : this.views) {
            view.envChanged(command);
        }
    }

    public boolean isDone() {
        for (Agent agent : this.agents) {
            if (!agent.isAlive()) continue;
            return false;
        }
        return true;
    }

    public void createExogenousChange() {
    }

    public void step() {
        if (!this.isDone()) {
            for (Agent agent : this.agents) {
                String anAction = agent.execute(this.getPerceptSeenBy(agent));
                this.updateViews(anAction);
                this.executeAction(agent, anAction);
            }
            this.createExogenousChange();
        }
    }

    public void step(int n) {
        for (int i = 0; i < n; ++i) {
            this.step();
        }
    }

    public void stepUntilDone() {
        while (!this.isDone()) {
            this.step();
        }
    }

    public ArrayList getAgents() {
        return this.agents;
    }

    public ArrayList getObjects() {
        return this.objects;
    }

    public boolean alreadyContains(EnvironmentObject o) {
        boolean retval = false;
        for (EnvironmentObject eo : this.objects) {
            if (!eo.equals(o)) continue;
            retval = true;
        }
        return retval;
    }

    public boolean alreadyContains(Agent anAgent) {
        boolean retval = false;
        for (Agent agent : this.agents) {
            if (!agent.equals(anAgent)) continue;
            retval = true;
        }
        return retval;
    }

    public void addAgent(Agent a, String attributeName, Object attributeValue) {
        if (!this.alreadyContains(a)) {
            a.setAttribute(attributeName, attributeValue);
            this.agents.add(a);
        }
    }

    public void addObject(EnvironmentObject o, String attributeName, Object attributeValue) {
        if (!this.alreadyContains(o)) {
            o.setAttribute(attributeName, attributeValue);
            this.objects.add(o);
        }
    }

    public void addObject(EnvironmentObject o) {
        if (!this.alreadyContains(o)) {
            this.objects.add(o);
        }
    }

    public void addAgent(Agent a) {
        if (!this.alreadyContains(a)) {
            this.agents.add(a);
        }
    }

    public List<ObjectWithDynamicAttributes> getAllObjects() {
        ArrayList<ObjectWithDynamicAttributes> l = new ArrayList<ObjectWithDynamicAttributes>();
        l.addAll(this.objects);
        l.addAll(this.agents);
        return l;
    }
}

