/*
 * Decompiled with CFR 0.152.
 */
package mcgraphresolver.controllers;

import com.jfoenix.controls.JFXRadioButton;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ToggleGroup;
import javafx.stage.Stage;
import mcgraphresolver.utils.SharePreferencesHandler;
import mcgraphresolver.utils.Utils;

public class ChooseAlgorithmController
implements Initializable {
    public Utils utils = new Utils();
    public JFXRadioButton radioButtonAStarSearch;
    public JFXRadioButton radioButtonDepthFirstSearch;
    public JFXRadioButton radioButtonBreadthFirstSearch;
    public JFXRadioButton radioButtonGreadyBestFirstSearch;
    public JFXRadioButton radioButtonUniformCostSearch;
    public JFXRadioButton radioButtonIterativeDeepeningSearch;
    public ToggleGroup toggleGroupAlgorithm;
    private ResourceBundle resourceBundle;
    private SharePreferencesHandler sharePreferencesHandler;
    private algorithm choosenAlgorithm = algorithm.ASTAR_SEARCH;
    private boolean confirmed = false;

    public void initialize(URL location, ResourceBundle resources) {
        this.resourceBundle = resources;
        this.radioButtonAStarSearch.setSelected(true);
        this.radioButtonAStarSearch.setToggleGroup(this.toggleGroupAlgorithm);
        this.radioButtonDepthFirstSearch.setToggleGroup(this.toggleGroupAlgorithm);
        this.radioButtonBreadthFirstSearch.setToggleGroup(this.toggleGroupAlgorithm);
        this.radioButtonGreadyBestFirstSearch.setToggleGroup(this.toggleGroupAlgorithm);
        this.radioButtonUniformCostSearch.setToggleGroup(this.toggleGroupAlgorithm);
        this.radioButtonIterativeDeepeningSearch.setToggleGroup(this.toggleGroupAlgorithm);
        this.radioButtonIterativeDeepeningSearch.setVisible(false);
        this.toggleGroupAlgorithm.selectedToggleProperty().addListener((ov, old_toggle, new_toggle) -> {
            JFXRadioButton chk = (JFXRadioButton)new_toggle.getToggleGroup().getSelectedToggle();
            this.choosenAlgorithm = chk.getText().equalsIgnoreCase(this.radioButtonAStarSearch.getText()) ? algorithm.ASTAR_SEARCH : (chk.getText().equalsIgnoreCase(this.radioButtonBreadthFirstSearch.getText()) ? algorithm.BREADTH_FIRST_SEARCH : (chk.getText().equalsIgnoreCase(this.radioButtonDepthFirstSearch.getText()) ? algorithm.DEPTH_FIRST_SEARCH : (chk.getText().equalsIgnoreCase(this.radioButtonGreadyBestFirstSearch.getText()) ? algorithm.GREEDY_BEST_FIRST_SEARCH : (chk.getText().equalsIgnoreCase(this.radioButtonUniformCostSearch.getText()) ? algorithm.UNIFORM_COST_SEARCH : (chk.getText().equalsIgnoreCase(this.radioButtonIterativeDeepeningSearch.getText()) ? algorithm.ITERATIVE_DEEPENING_SEARCH : algorithm.ASTAR_SEARCH)))));
        });
    }

    public void setSharePreferencesHandles(SharePreferencesHandler sharePreferencesHandler) {
        this.sharePreferencesHandler = sharePreferencesHandler;
    }

    public void populateItems() {
    }

    public algorithm getSelectedAlgorithm() {
        return this.confirmed ? this.choosenAlgorithm : null;
    }

    @FXML
    private void handleSaveAction(ActionEvent event) {
        this.confirmed = true;
        Node source = (Node)event.getSource();
        Stage stage = (Stage)source.getScene().getWindow();
        stage.close();
    }

    @FXML
    private void handleExitAction(ActionEvent event) {
        this.confirmed = false;
        Node source = (Node)event.getSource();
        Stage stage = (Stage)source.getScene().getWindow();
        stage.close();
    }

    public static enum algorithm {
        ASTAR_SEARCH,
        BREADTH_FIRST_SEARCH,
        DEPTH_FIRST_SEARCH,
        GREEDY_BEST_FIRST_SEARCH,
        UNIFORM_COST_SEARCH,
        ITERATIVE_DEEPENING_SEARCH;

    }
}

