/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls.behavior;

import com.jfoenix.skins.JFXColorPickerSkin;
import com.sun.javafx.scene.control.behavior.ComboBoxBaseBehavior;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.paint.Color;

public class JFXColorPickerBehavior
extends ComboBoxBaseBehavior<Color> {
    protected static final String JFX_OPEN_ACTION = "Open";
    protected static final String JFX_CLOSE_ACTION = "Close";
    protected static final List<KeyBinding> JFX_COLOR_PICKER_BINDINGS = new ArrayList<KeyBinding>();

    public JFXColorPickerBehavior(ColorPicker colorPicker) {
        super((ComboBoxBase)colorPicker, JFX_COLOR_PICKER_BINDINGS);
    }

    protected void callAction(String name) {
        if (JFX_OPEN_ACTION.equals(name)) {
            this.show();
        } else if (JFX_CLOSE_ACTION.equals(name)) {
            this.hide();
        } else {
            super.callAction(name);
        }
    }

    public void onAutoHide() {
        ColorPicker colorPicker = (ColorPicker)this.getControl();
        JFXColorPickerSkin cpSkin = (JFXColorPickerSkin)colorPicker.getSkin();
        cpSkin.syncWithAutoUpdate();
        if (!colorPicker.isShowing()) {
            super.onAutoHide();
        }
    }

    static {
        JFX_COLOR_PICKER_BINDINGS.add(new KeyBinding(KeyCode.ESCAPE, KeyEvent.KEY_PRESSED, JFX_CLOSE_ACTION));
        JFX_COLOR_PICKER_BINDINGS.add(new KeyBinding(KeyCode.SPACE, KeyEvent.KEY_PRESSED, JFX_OPEN_ACTION));
        JFX_COLOR_PICKER_BINDINGS.add(new KeyBinding(KeyCode.ENTER, KeyEvent.KEY_PRESSED, JFX_OPEN_ACTION));
    }
}

