/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.JFXComboBox$$Lambda$1;
import com.jfoenix.controls.JFXComboBox$2$$Lambda$1;
import com.jfoenix.controls.JFXListCell;
import com.jfoenix.converters.base.NodeConverter;
import com.jfoenix.skins.JFXComboBoxListViewSkin;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.PaintConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.StringConverter;

public class JFXComboBox<T>
extends ComboBox<T> {
    private static final String DEFAULT_STYLE_CLASS = "jfx-combo-box";
    private ObjectProperty<NodeConverter<T>> nodeConverter = new SimpleObjectProperty((Object)this, "nodeConverter", JFXComboBox.<T>defaultNodeConverter());
    private StyleableBooleanProperty labelFloat = new SimpleStyleableBooleanProperty(StyleableProperties.access$100(), (Object)this, "lableFloat", false);
    private StyleableObjectProperty<Paint> unFocusColor = new SimpleStyleableObjectProperty(StyleableProperties.access$200(), (Object)this, "unFocusColor", (Object)Color.rgb((int)77, (int)77, (int)77));
    private StyleableObjectProperty<Paint> focusColor = new SimpleStyleableObjectProperty(StyleableProperties.access$300(), (Object)this, "focusColor", (Object)Color.valueOf((String)"#4059A9"));
    private List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public JFXComboBox() {
        this.initialize();
    }

    public JFXComboBox(ObservableList<T> items) {
        super(items);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setCellFactory(JFXComboBox$$Lambda$1.lambdaFactory$(this));
        this.setButtonCell(new ListCell<T>(){
            {
                JFXComboBox.this.valueProperty().addListener(JFXComboBox$2$$Lambda$1.lambdaFactory$(this));
            }

            protected void updateItem(T item, boolean empty) {
                JFXComboBox.this.updateDisplayText(this, item, empty);
                this.setVisible(item != null || !empty);
            }

            static /* synthetic */ void lambda$new$0(2 this_, Observable observable) {
                if (this_.JFXComboBox.this.getValue() == null) {
                    this_.updateItem(null, true);
                }
            }
        });
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("/css/controls/jfx-combo-box.css").toExternalForm();
    }

    protected Skin<?> createDefaultSkin() {
        return new JFXComboBoxListViewSkin(this);
    }

    public ObjectProperty<NodeConverter<T>> nodeConverterProperty() {
        return this.nodeConverter;
    }

    public final void setNodeConverter(NodeConverter<T> value) {
        this.nodeConverterProperty().set(value);
    }

    public final NodeConverter<T> getNodeConverter() {
        return (NodeConverter)this.nodeConverterProperty().get();
    }

    private static <T> NodeConverter<T> defaultNodeConverter() {
        return new NodeConverter<T>(){

            @Override
            public Node toNode(T object) {
                if (object == null) {
                    return null;
                }
                StackPane selectedValueContainer = new StackPane();
                selectedValueContainer.getStyleClass().add((Object)"combo-box-selected-value-container");
                selectedValueContainer.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, null, null)}));
                Label selectedValueLabel = object instanceof Label ? new Label(((Label)object).getText()) : new Label(object.toString());
                selectedValueLabel.setTextFill((Paint)Color.BLACK);
                selectedValueContainer.getChildren().add((Object)selectedValueLabel);
                StackPane.setAlignment((Node)selectedValueLabel, (Pos)Pos.CENTER_LEFT);
                StackPane.setMargin((Node)selectedValueLabel, (Insets)new Insets(0.0, 0.0, 0.0, 5.0));
                return selectedValueContainer;
            }

            @Override
            public T fromNode(Node node) {
                return node;
            }

            @Override
            public String toString(T object) {
                if (object == null) {
                    return null;
                }
                if (object instanceof Label) {
                    return ((Label)object).getText();
                }
                return object.toString();
            }
        };
    }

    private boolean updateDisplayText(ListCell<T> cell, T item, boolean empty) {
        if (empty) {
            if (cell == null) {
                return true;
            }
            cell.setGraphic(null);
            cell.setText(null);
            return true;
        }
        if (item instanceof Node) {
            Node node;
            Node currentNode = cell.getGraphic();
            Node newNode = (Node)item;
            NodeConverter<T> nc = this.getNodeConverter();
            Node node2 = node = nc == null ? null : nc.toNode(item);
            if (currentNode == null || !currentNode.equals(newNode)) {
                cell.setText(null);
                cell.setGraphic(node == null ? newNode : node);
            }
            return node == null;
        }
        StringConverter c = this.getConverter();
        String s = item == null ? this.getPromptText() : (c == null ? item.toString() : c.toString(item));
        cell.setText(s);
        cell.setGraphic(null);
        return s == null || s.isEmpty();
    }

    public final StyleableBooleanProperty labelFloatProperty() {
        return this.labelFloat;
    }

    public final boolean isLabelFloat() {
        return this.labelFloatProperty().get();
    }

    public final void setLabelFloat(boolean labelFloat) {
        this.labelFloatProperty().set(labelFloat);
    }

    public Paint getUnFocusColor() {
        return this.unFocusColor == null ? Color.rgb((int)77, (int)77, (int)77) : (Paint)this.unFocusColor.get();
    }

    public StyleableObjectProperty<Paint> unFocusColorProperty() {
        return this.unFocusColor;
    }

    public void setUnFocusColor(Paint color) {
        this.unFocusColor.set((Object)color);
    }

    public Paint getFocusColor() {
        return this.focusColor == null ? Color.valueOf((String)"#4059A9") : (Paint)this.focusColor.get();
    }

    public StyleableObjectProperty<Paint> focusColorProperty() {
        return this.focusColor;
    }

    public void setFocusColor(Paint color) {
        this.focusColor.set((Object)color);
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        if (this.STYLEABLES == null) {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            styleables.addAll(JFXComboBox.getClassCssMetaData());
            styleables.addAll(Control.getClassCssMetaData());
            this.STYLEABLES = Collections.unmodifiableList(styleables);
        }
        return this.STYLEABLES;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.CHILD_STYLEABLES;
    }

    static /* synthetic */ ListCell lambda$initialize$0(JFXComboBox this_, ListView listView) {
        return new JFXListCell<T>(){

            @Override
            public void updateItem(T item, boolean empty) {
                super.updateItem(item, empty);
                JFXComboBox.this.updateDisplayText(this, item, empty);
            }
        };
    }

    private static class StyleableProperties {
        private static final CssMetaData<JFXComboBox<?>, Paint> UNFOCUS_COLOR = new CssMetaData<JFXComboBox<?>, Paint>("-jfx-unfocus-color", PaintConverter.getInstance(), (Paint)Color.valueOf((String)"#A6A6A6")){

            public boolean isSettable(JFXComboBox<?> control) {
                return ((JFXComboBox)control).unFocusColor == null || !((JFXComboBox)control).unFocusColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(JFXComboBox<?> control) {
                return control.unFocusColorProperty();
            }
        };
        private static final CssMetaData<JFXComboBox<?>, Paint> FOCUS_COLOR = new CssMetaData<JFXComboBox<?>, Paint>("-jfx-focus-color", PaintConverter.getInstance(), (Paint)Color.valueOf((String)"#3f51b5")){

            public boolean isSettable(JFXComboBox<?> control) {
                return ((JFXComboBox)control).focusColor == null || !((JFXComboBox)control).focusColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(JFXComboBox<?> control) {
                return control.focusColorProperty();
            }
        };
        private static final CssMetaData<JFXComboBox<?>, Boolean> LABEL_FLOAT = new CssMetaData<JFXComboBox<?>, Boolean>("-jfx-label-float", BooleanConverter.getInstance(), false){

            public boolean isSettable(JFXComboBox<?> control) {
                return ((JFXComboBox)control).labelFloat == null || !((JFXComboBox)control).labelFloat.isBound();
            }

            public StyleableBooleanProperty getStyleableProperty(JFXComboBox<?> control) {
                return control.labelFloatProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$100() {
            return LABEL_FLOAT;
        }

        static /* synthetic */ CssMetaData access$200() {
            return UNFOCUS_COLOR;
        }

        static /* synthetic */ CssMetaData access$300() {
            return FOCUS_COLOR;
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, UNFOCUS_COLOR, FOCUS_COLOR, LABEL_FLOAT);
            CHILD_STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

