/*
 * Decompiled with CFR 0.152.
 */
package aima.util;

import java.util.Hashtable;
import java.util.List;

public class Table<RowHeaderType, ColumnHeaderType, ValueType> {
    private List<RowHeaderType> rowHeaders;
    private List<ColumnHeaderType> columnHeaders;
    private Hashtable<RowHeaderType, Hashtable<ColumnHeaderType, ValueType>> rows;

    public Table(List<RowHeaderType> rowHeaders, List<ColumnHeaderType> columnHeaders) {
        this.rowHeaders = rowHeaders;
        this.columnHeaders = columnHeaders;
        this.rows = new Hashtable();
        for (RowHeaderType rowHeader : rowHeaders) {
            this.rows.put(rowHeader, new Hashtable());
        }
    }

    public void set(RowHeaderType r, ColumnHeaderType c, ValueType v) {
        this.rows.get(r).put(c, v);
    }

    public ValueType get(RowHeaderType r, ColumnHeaderType c) {
        Hashtable<ColumnHeaderType, ValueType> rowValues = this.rows.get(r);
        return rowValues == null ? null : (ValueType)rowValues.get(c);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (RowHeaderType r : this.rowHeaders) {
            Hashtable<ColumnHeaderType, ValueType> rowValues = this.rows.get(r);
            for (ColumnHeaderType c : this.columnHeaders) {
                buf.append(this.get(r, c).toString());
                buf.append(" ");
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    class Cell<ValueHeaderType> {
        private ValueHeaderType value;

        public Cell() {
            this.value = null;
        }

        public Cell(ValueHeaderType value) {
            this.value = value;
        }

        public void set(ValueHeaderType value) {
            this.value = value;
        }

        public ValueHeaderType value() {
            return this.value;
        }
    }

    class Row<R> {
        private Hashtable<ColumnHeaderType, ValueType> cells = new Hashtable();

        public Hashtable<ColumnHeaderType, ValueType> cells() {
            return this.cells;
        }
    }
}

