/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.eightpuzzle;

import aima.basic.XYLocation;
import aima.search.eightpuzzle.EightPuzzleBoard;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class EightPuzzleBoardTest
extends TestCase {
    EightPuzzleBoard board;

    @Override
    public void setUp() {
        this.board = new EightPuzzleBoard();
    }

    public void testGetBoard() {
        int[] expected = new int[]{5, 4, 0, 6, 1, 8, 7, 3, 2};
        int[] boardRepr = this.board.getBoard();
        EightPuzzleBoardTest.assertEquals(expected[0], boardRepr[0]);
        EightPuzzleBoardTest.assertEquals(expected[1], boardRepr[1]);
        EightPuzzleBoardTest.assertEquals(expected[2], boardRepr[2]);
        EightPuzzleBoardTest.assertEquals(expected[3], boardRepr[3]);
        EightPuzzleBoardTest.assertEquals(expected[4], boardRepr[4]);
        EightPuzzleBoardTest.assertEquals(expected[5], boardRepr[5]);
        EightPuzzleBoardTest.assertEquals(expected[6], boardRepr[6]);
        EightPuzzleBoardTest.assertEquals(expected[7], boardRepr[7]);
        EightPuzzleBoardTest.assertEquals(expected[8], boardRepr[8]);
    }

    public void testGetLocation() {
        EightPuzzleBoardTest.assertEquals(new XYLocation(0, 2), this.board.getLocationOf(0));
        EightPuzzleBoardTest.assertEquals(new XYLocation(1, 1), this.board.getLocationOf(1));
        EightPuzzleBoardTest.assertEquals(new XYLocation(2, 2), this.board.getLocationOf(2));
        EightPuzzleBoardTest.assertEquals(new XYLocation(2, 1), this.board.getLocationOf(3));
        EightPuzzleBoardTest.assertEquals(new XYLocation(0, 1), this.board.getLocationOf(4));
        EightPuzzleBoardTest.assertEquals(new XYLocation(0, 0), this.board.getLocationOf(5));
        EightPuzzleBoardTest.assertEquals(new XYLocation(1, 0), this.board.getLocationOf(6));
        EightPuzzleBoardTest.assertEquals(new XYLocation(2, 0), this.board.getLocationOf(7));
        EightPuzzleBoardTest.assertEquals(new XYLocation(1, 2), this.board.getLocationOf(8));
    }

    public void testGetValueAt() {
        EightPuzzleBoardTest.assertEquals(5, this.board.getValueAt(new XYLocation(0, 0)));
        EightPuzzleBoardTest.assertEquals(4, this.board.getValueAt(new XYLocation(0, 1)));
        EightPuzzleBoardTest.assertEquals(0, this.board.getValueAt(new XYLocation(0, 2)));
        EightPuzzleBoardTest.assertEquals(6, this.board.getValueAt(new XYLocation(1, 0)));
        EightPuzzleBoardTest.assertEquals(1, this.board.getValueAt(new XYLocation(1, 1)));
        EightPuzzleBoardTest.assertEquals(8, this.board.getValueAt(new XYLocation(1, 2)));
        EightPuzzleBoardTest.assertEquals(7, this.board.getValueAt(new XYLocation(2, 0)));
        EightPuzzleBoardTest.assertEquals(3, this.board.getValueAt(new XYLocation(2, 1)));
        EightPuzzleBoardTest.assertEquals(2, this.board.getValueAt(new XYLocation(2, 2)));
    }

    public void testGetPositions() {
        ArrayList<XYLocation> expected = new ArrayList<XYLocation>();
        expected.add(new XYLocation(0, 2));
        expected.add(new XYLocation(1, 1));
        expected.add(new XYLocation(2, 2));
        expected.add(new XYLocation(2, 1));
        expected.add(new XYLocation(0, 1));
        expected.add(new XYLocation(0, 0));
        expected.add(new XYLocation(1, 0));
        expected.add(new XYLocation(2, 0));
        expected.add(new XYLocation(1, 2));
        List<XYLocation> actual = this.board.getPositions();
        EightPuzzleBoardTest.assertEquals(expected, actual);
    }

    public void testSetBoard() {
        ArrayList<XYLocation> passedIn = new ArrayList<XYLocation>();
        passedIn.add(new XYLocation(1, 1));
        passedIn.add(new XYLocation(0, 2));
        passedIn.add(new XYLocation(2, 2));
        passedIn.add(new XYLocation(2, 1));
        passedIn.add(new XYLocation(0, 1));
        passedIn.add(new XYLocation(0, 0));
        passedIn.add(new XYLocation(1, 0));
        passedIn.add(new XYLocation(2, 0));
        passedIn.add(new XYLocation(1, 2));
        this.board.setBoard(passedIn);
        EightPuzzleBoardTest.assertEquals(new XYLocation(1, 1), this.board.getLocationOf(0));
        EightPuzzleBoardTest.assertEquals(new XYLocation(0, 2), this.board.getLocationOf(1));
    }
}

