/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.foltest;

import aima.logic.fol.CNFConverter;
import aima.logic.fol.StandardizeApartIndexicalFactory;
import aima.logic.fol.domain.DomainFactory;
import aima.logic.fol.domain.FOLDomain;
import aima.logic.fol.kb.FOLKnowledgeBase;
import aima.logic.fol.kb.data.CNF;
import aima.logic.fol.kb.data.Clause;
import aima.logic.fol.kb.data.Literal;
import aima.logic.fol.parsing.FOLParser;
import aima.logic.fol.parsing.ast.AtomicSentence;
import aima.logic.fol.parsing.ast.Constant;
import aima.logic.fol.parsing.ast.Function;
import aima.logic.fol.parsing.ast.Predicate;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import junit.framework.TestCase;

public class ClauseTest
extends TestCase {
    @Override
    public void setUp() {
        StandardizeApartIndexicalFactory.flush();
    }

    public void testImmutable() {
        Clause c = new Clause();
        ClauseTest.assertFalse(c.isImmutable());
        c.addNegativeLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        c.addPositiveLiteral(new Predicate("Pred2", new ArrayList<Term>()));
        c.setImmutable();
        ClauseTest.assertTrue(c.isImmutable());
        try {
            c.addNegativeLiteral(new Predicate("Pred3", new ArrayList<Term>()));
            ClauseTest.fail("Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            c.addPositiveLiteral(new Predicate("Pred3", new ArrayList<Term>()));
            ClauseTest.fail("Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testIsEmpty() {
        Clause c1 = new Clause();
        ClauseTest.assertTrue(c1.isEmpty());
        c1.addNegativeLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        ClauseTest.assertFalse(c1.isEmpty());
        Clause c2 = new Clause();
        ClauseTest.assertTrue(c2.isEmpty());
        c2.addPositiveLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        ClauseTest.assertFalse(c2.isEmpty());
        Clause c3 = new Clause();
        ClauseTest.assertTrue(c3.isEmpty());
        c3.addNegativeLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        c3.addPositiveLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        ClauseTest.assertFalse(c3.isEmpty());
        c3.addNegativeLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        c3.addPositiveLiteral(new Predicate("Pred2", new ArrayList<Term>()));
        ClauseTest.assertFalse(c3.isEmpty());
    }

    public void testIsHornClause() {
        Clause c1 = new Clause();
        ClauseTest.assertFalse(c1.isHornClause());
        c1.addNegativeLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        ClauseTest.assertTrue(c1.isHornClause());
        c1.addPositiveLiteral(new Predicate("Pred2", new ArrayList<Term>()));
        ClauseTest.assertTrue(c1.isHornClause());
        c1.addNegativeLiteral(new Predicate("Pred3", new ArrayList<Term>()));
        ClauseTest.assertTrue(c1.isHornClause());
        c1.addNegativeLiteral(new Predicate("Pred4", new ArrayList<Term>()));
        ClauseTest.assertTrue(c1.isHornClause());
        c1.addPositiveLiteral(new Predicate("Pred5", new ArrayList<Term>()));
        ClauseTest.assertFalse(c1.isHornClause());
    }

    public void testIsDefiniteClause() {
        Clause c1 = new Clause();
        ClauseTest.assertFalse(c1.isDefiniteClause());
        c1.addNegativeLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        ClauseTest.assertFalse(c1.isDefiniteClause());
        c1.addPositiveLiteral(new Predicate("Pred2", new ArrayList<Term>()));
        ClauseTest.assertTrue(c1.isDefiniteClause());
        c1.addNegativeLiteral(new Predicate("Pred3", new ArrayList<Term>()));
        ClauseTest.assertTrue(c1.isDefiniteClause());
        c1.addNegativeLiteral(new Predicate("Pred4", new ArrayList<Term>()));
        ClauseTest.assertTrue(c1.isDefiniteClause());
        c1.addPositiveLiteral(new Predicate("Pred5", new ArrayList<Term>()));
        ClauseTest.assertFalse(c1.isDefiniteClause());
    }

    public void testIsUnitClause() {
        Clause c1 = new Clause();
        ClauseTest.assertFalse(c1.isUnitClause());
        c1.addPositiveLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        ClauseTest.assertTrue(c1.isUnitClause());
        c1.addPositiveLiteral(new Predicate("Pred2", new ArrayList<Term>()));
        ClauseTest.assertFalse(c1.isUnitClause());
        c1 = new Clause();
        ClauseTest.assertFalse(c1.isUnitClause());
        c1.addPositiveLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        ClauseTest.assertTrue(c1.isUnitClause());
        c1.addNegativeLiteral(new Predicate("Pred2", new ArrayList<Term>()));
        ClauseTest.assertFalse(c1.isUnitClause());
        c1 = new Clause();
        ClauseTest.assertFalse(c1.isUnitClause());
        c1.addNegativeLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        ClauseTest.assertTrue(c1.isUnitClause());
        c1.addPositiveLiteral(new Predicate("Pred2", new ArrayList<Term>()));
        ClauseTest.assertFalse(c1.isUnitClause());
    }

    public void testIsImplicationDefiniteClause() {
        Clause c1 = new Clause();
        ClauseTest.assertFalse(c1.isImplicationDefiniteClause());
        c1.addPositiveLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        ClauseTest.assertFalse(c1.isImplicationDefiniteClause());
        c1.addNegativeLiteral(new Predicate("Pred2", new ArrayList<Term>()));
        ClauseTest.assertTrue(c1.isImplicationDefiniteClause());
        c1.addNegativeLiteral(new Predicate("Pred3", new ArrayList<Term>()));
        ClauseTest.assertTrue(c1.isImplicationDefiniteClause());
        c1.addPositiveLiteral(new Predicate("Pred4", new ArrayList<Term>()));
        ClauseTest.assertFalse(c1.isImplicationDefiniteClause());
    }

    public void testBinaryResolvents() {
        FOLDomain domain = new FOLDomain();
        domain.addPredicate("Pred1");
        domain.addPredicate("Pred2");
        domain.addPredicate("Pred3");
        domain.addPredicate("Pred4");
        Clause c1 = new Clause();
        ClauseTest.assertNotNull(c1.binaryResolvents(c1));
        ClauseTest.assertEquals(1, c1.binaryResolvents(c1).size());
        ClauseTest.assertTrue(c1.binaryResolvents(c1).iterator().next().isEmpty());
        c1.addPositiveLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        c1.addNegativeLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        ClauseTest.assertNotNull(c1.binaryResolvents(c1));
        ClauseTest.assertEquals(1, c1.binaryResolvents(c1).size());
        ClauseTest.assertEquals("[~Pred1(), Pred1()]", c1.binaryResolvents(c1).iterator().next().toString());
        c1 = new Clause();
        c1.addPositiveLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        ClauseTest.assertEquals(0, c1.binaryResolvents(c1).size());
        c1 = new Clause();
        Clause c2 = new Clause();
        ClauseTest.assertNotNull(c1.binaryResolvents(c2));
        ClauseTest.assertEquals(1, c1.binaryResolvents(c2).size());
        ClauseTest.assertTrue(c1.binaryResolvents(c2).iterator().next().isEmpty());
        ClauseTest.assertNotNull(c2.binaryResolvents(c1));
        ClauseTest.assertEquals(1, c2.binaryResolvents(c1).size());
        ClauseTest.assertTrue(c2.binaryResolvents(c1).iterator().next().isEmpty());
        c1.addPositiveLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        c2.addNegativeLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        ClauseTest.assertNotNull(c1.binaryResolvents(c2));
        ClauseTest.assertEquals(1, c1.binaryResolvents(c2).size());
        ClauseTest.assertTrue(c1.binaryResolvents(c2).iterator().next().isEmpty());
        ClauseTest.assertNotNull(c2.binaryResolvents(c1));
        ClauseTest.assertEquals(1, c2.binaryResolvents(c1).size());
        ClauseTest.assertTrue(c2.binaryResolvents(c1).iterator().next().isEmpty());
        c1.addPositiveLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        c2.addNegativeLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        c1.addPositiveLiteral(new Predicate("Pred2", new ArrayList<Term>()));
        c2.addNegativeLiteral(new Predicate("Pred2", new ArrayList<Term>()));
        ClauseTest.assertNotNull(c1.binaryResolvents(c2));
        ClauseTest.assertEquals(2, c1.binaryResolvents(c2).size());
        ClauseTest.assertNotNull(c2.binaryResolvents(c1));
        ClauseTest.assertEquals(2, c2.binaryResolvents(c1).size());
        c1 = new Clause();
        c2 = new Clause();
        c1.addPositiveLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        c1.addPositiveLiteral(new Predicate("Pred2", new ArrayList<Term>()));
        c1.addNegativeLiteral(new Predicate("Pred3", new ArrayList<Term>()));
        c1.addNegativeLiteral(new Predicate("Pred4", new ArrayList<Term>()));
        c2.addPositiveLiteral(new Predicate("Pred2", new ArrayList<Term>()));
        c2.addNegativeLiteral(new Predicate("Pred4", new ArrayList<Term>()));
        ClauseTest.assertNotNull(c1.binaryResolvents(c2));
        ClauseTest.assertEquals(0, c1.binaryResolvents(c2).size());
        ClauseTest.assertNotNull(c2.binaryResolvents(c1));
        ClauseTest.assertEquals(0, c2.binaryResolvents(c1).size());
        c1 = new Clause();
        c2 = new Clause();
        c1.addPositiveLiteral(new Predicate("Pred1", new ArrayList<Term>()));
        c1.addNegativeLiteral(new Predicate("Pred2", new ArrayList<Term>()));
        c1.addNegativeLiteral(new Predicate("Pred3", new ArrayList<Term>()));
        c2.addPositiveLiteral(new Predicate("Pred2", new ArrayList<Term>()));
        ClauseTest.assertNotNull(c1.binaryResolvents(c2));
        ClauseTest.assertNotNull(c2.binaryResolvents(c1));
        ClauseTest.assertEquals(1, c1.binaryResolvents(c2).iterator().next().getNumberPositiveLiterals());
        ClauseTest.assertEquals(1, c1.binaryResolvents(c2).iterator().next().getNumberNegativeLiterals());
        ClauseTest.assertEquals(1, c2.binaryResolvents(c1).iterator().next().getNumberPositiveLiterals());
        ClauseTest.assertEquals(1, c2.binaryResolvents(c1).iterator().next().getNumberNegativeLiterals());
    }

    public void testBinaryResolventsOrderDoesNotMatter() {
        FOLKnowledgeBase kb = new FOLKnowledgeBase(DomainFactory.lovesAnimalDomain());
        kb.tell("FORALL x (FORALL y (Animal(y) => Loves(x, y)) => EXISTS y Loves(y, x))");
        kb.tell("FORALL x (EXISTS y (Animal(y) AND Kills(x, y)) => FORALL z NOT(Loves(z, x)))");
        kb.tell("FORALL x (Animal(x) => Loves(Jack, x))");
        kb.tell("(Kills(Jack, Tuna) OR Kills(Curiosity, Tuna))");
        kb.tell("Cat(Tuna)");
        kb.tell("FORALL x (Cat(x) => Animal(x))");
        LinkedHashSet<Clause> clauses = new LinkedHashSet<Clause>();
        clauses.addAll(kb.getAllClauses());
        LinkedHashSet<Clause> newClauses = new LinkedHashSet<Clause>();
        long maxRunTime = 30000L;
        long finishTime = System.currentTimeMillis() + maxRunTime;
        block0: do {
            clauses.addAll(newClauses);
            newClauses.clear();
            Clause[] clausesA = new Clause[clauses.size()];
            clauses.toArray(clausesA);
            for (int i = 0; i < clausesA.length; ++i) {
                Clause cI = clausesA[i];
                for (int j = 0; j < clausesA.length; ++j) {
                    Clause cJ = clausesA[j];
                    newClauses.addAll(cI.getFactors());
                    newClauses.addAll(cJ.getFactors());
                    Set<Clause> cIresolvents = cI.binaryResolvents(cJ);
                    Set<Clause> cJresolvents = cJ.binaryResolvents(cI);
                    if (!cIresolvents.equals(cJresolvents)) {
                        System.err.println("cI=" + cI);
                        System.err.println("cJ=" + cJ);
                        System.err.println("cIR=" + cIresolvents);
                        System.err.println("cJR=" + cJresolvents);
                        ClauseTest.fail("Ordering of binary resolvents has become important, which should not be the case");
                    }
                    for (Clause r : cIresolvents) {
                        newClauses.addAll(r.getFactors());
                    }
                    if (System.currentTimeMillis() > finishTime) break;
                }
                if (System.currentTimeMillis() > finishTime) continue block0;
            }
        } while (System.currentTimeMillis() < finishTime);
    }

    public void testEqualityBinaryResolvents() {
        FOLDomain domain = new FOLDomain();
        domain.addConstant("A");
        domain.addConstant("B");
        FOLParser parser = new FOLParser(domain);
        Clause c1 = new Clause();
        c1.addPositiveLiteral((AtomicSentence)parser.parse("B = A"));
        Clause c2 = new Clause();
        c2.addNegativeLiteral((AtomicSentence)parser.parse("B = A"));
        c2.addPositiveLiteral((AtomicSentence)parser.parse("B = A"));
        Set<Clause> resolvents = c1.binaryResolvents(c2);
        ClauseTest.assertEquals(1, resolvents.size());
        ClauseTest.assertEquals("[[B = A]]", resolvents.toString());
    }

    public void testHashCode() {
        Constant cons1 = new Constant("C1");
        Constant cons2 = new Constant("C2");
        Variable var1 = new Variable("v1");
        ArrayList<Term> pts1 = new ArrayList<Term>();
        ArrayList<Term> pts2 = new ArrayList<Term>();
        pts1.add(cons1);
        pts1.add(cons2);
        pts1.add(var1);
        pts2.add(cons2);
        pts2.add(cons1);
        pts2.add(var1);
        Clause c1 = new Clause();
        Clause c2 = new Clause();
        ClauseTest.assertEquals(c1.hashCode(), c2.hashCode());
        c1.addNegativeLiteral(new Predicate("Pred1", pts1));
        ClauseTest.assertNotSame(c1.hashCode(), c2.hashCode());
        c2.addNegativeLiteral(new Predicate("Pred1", pts1));
        ClauseTest.assertEquals(c1.hashCode(), c2.hashCode());
        c1.addPositiveLiteral(new Predicate("Pred1", pts1));
        ClauseTest.assertNotSame(c1.hashCode(), c2.hashCode());
        c2.addPositiveLiteral(new Predicate("Pred1", pts1));
        ClauseTest.assertEquals(c1.hashCode(), c2.hashCode());
    }

    public void testSimpleEquals() {
        Constant cons1 = new Constant("C1");
        Constant cons2 = new Constant("C2");
        Variable var1 = new Variable("v1");
        ArrayList<Term> pts1 = new ArrayList<Term>();
        ArrayList<Term> pts2 = new ArrayList<Term>();
        pts1.add(cons1);
        pts1.add(cons2);
        pts1.add(var1);
        pts2.add(cons2);
        pts2.add(cons1);
        pts2.add(var1);
        Clause c1 = new Clause();
        Clause c2 = new Clause();
        ClauseTest.assertTrue(c1.equals(c1));
        ClauseTest.assertTrue(c2.equals(c2));
        ClauseTest.assertTrue(c1.equals(c2));
        ClauseTest.assertTrue(c2.equals(c1));
        c1.addNegativeLiteral(new Predicate("Pred1", pts1));
        ClauseTest.assertFalse(c1.equals(c2));
        ClauseTest.assertFalse(c2.equals(c1));
        c2.addNegativeLiteral(new Predicate("Pred1", pts1));
        ClauseTest.assertTrue(c1.equals(c2));
        ClauseTest.assertTrue(c2.equals(c1));
        c1.addNegativeLiteral(new Predicate("Pred2", pts2));
        ClauseTest.assertFalse(c1.equals(c2));
        ClauseTest.assertFalse(c2.equals(c1));
        c2.addNegativeLiteral(new Predicate("Pred2", pts2));
        ClauseTest.assertTrue(c1.equals(c2));
        ClauseTest.assertTrue(c2.equals(c1));
        c1.addNegativeLiteral(new Predicate("Pred3", pts1));
        ClauseTest.assertFalse(c1.equals(c2));
        ClauseTest.assertFalse(c2.equals(c1));
        c1.addNegativeLiteral(new Predicate("Pred4", pts1));
        ClauseTest.assertFalse(c1.equals(c2));
        ClauseTest.assertFalse(c2.equals(c1));
        c2.addNegativeLiteral(new Predicate("Pred4", pts1));
        ClauseTest.assertFalse(c1.equals(c2));
        ClauseTest.assertFalse(c2.equals(c1));
        c2.addNegativeLiteral(new Predicate("Pred3", pts1));
        ClauseTest.assertTrue(c1.equals(c2));
        ClauseTest.assertTrue(c2.equals(c1));
        c1.addPositiveLiteral(new Predicate("Pred1", pts1));
        ClauseTest.assertFalse(c1.equals(c2));
        ClauseTest.assertFalse(c2.equals(c1));
        c2.addPositiveLiteral(new Predicate("Pred1", pts1));
        ClauseTest.assertTrue(c1.equals(c2));
        ClauseTest.assertTrue(c2.equals(c1));
        c1.addPositiveLiteral(new Predicate("Pred2", pts2));
        ClauseTest.assertFalse(c1.equals(c2));
        ClauseTest.assertFalse(c2.equals(c1));
        c2.addPositiveLiteral(new Predicate("Pred2", pts2));
        ClauseTest.assertTrue(c1.equals(c2));
        ClauseTest.assertTrue(c2.equals(c1));
        c1.addPositiveLiteral(new Predicate("Pred3", pts1));
        ClauseTest.assertFalse(c1.equals(c2));
        ClauseTest.assertFalse(c2.equals(c1));
        c1.addPositiveLiteral(new Predicate("Pred4", pts1));
        ClauseTest.assertFalse(c1.equals(c2));
        ClauseTest.assertFalse(c2.equals(c1));
        c2.addPositiveLiteral(new Predicate("Pred4", pts1));
        ClauseTest.assertFalse(c1.equals(c2));
        ClauseTest.assertFalse(c2.equals(c1));
        c2.addPositiveLiteral(new Predicate("Pred3", pts1));
        ClauseTest.assertTrue(c1.equals(c2));
        ClauseTest.assertTrue(c2.equals(c1));
    }

    public void testComplexEquals() {
        FOLDomain domain = new FOLDomain();
        domain.addConstant("A");
        domain.addConstant("B");
        domain.addConstant("C");
        domain.addConstant("D");
        domain.addPredicate("P");
        domain.addPredicate("Animal");
        domain.addPredicate("Kills");
        domain.addFunction("F");
        domain.addFunction("SF0");
        FOLParser parser = new FOLParser(domain);
        CNFConverter cnfConverter = new CNFConverter(parser);
        Sentence s1 = parser.parse("((x1 = y1 AND y1 = z1) => x1 = z1)");
        Sentence s2 = parser.parse("((x2 = y2 AND F(y2) = z2) => F(x2) = z2)");
        CNF cnf1 = cnfConverter.convertToCNF(s1);
        CNF cnf2 = cnfConverter.convertToCNF(s2);
        Clause c1 = cnf1.getConjunctionOfClauses().get(0);
        Clause c2 = cnf2.getConjunctionOfClauses().get(0);
        ClauseTest.assertFalse(c1.equals(c2));
        s1 = parser.parse("((x1 = y1 AND y1 = z1) => x1 = z1)");
        s2 = parser.parse("((x2 = y2 AND y2 = z2) => x2 = z2)");
        cnf1 = cnfConverter.convertToCNF(s1);
        cnf2 = cnfConverter.convertToCNF(s2);
        c1 = cnf1.getConjunctionOfClauses().get(0);
        c2 = cnf2.getConjunctionOfClauses().get(0);
        ClauseTest.assertTrue(c1.equals(c2));
        s1 = parser.parse("((x1 = y1 AND y1 = z1) => x1 = z1)");
        s2 = parser.parse("((y2 = z2 AND x2 = y2) => x2 = z2)");
        cnf1 = cnfConverter.convertToCNF(s1);
        cnf2 = cnfConverter.convertToCNF(s2);
        c1 = cnf1.getConjunctionOfClauses().get(0);
        c2 = cnf2.getConjunctionOfClauses().get(0);
        ClauseTest.assertTrue(c1.equals(c2));
        s1 = parser.parse("(((x1 = y1 AND y1 = z1) AND z1 = r1) => x1 = r1)");
        s2 = parser.parse("(((x2 = y2 AND y2 = z2) AND z2 = r2) => x2 = r2)");
        cnf1 = cnfConverter.convertToCNF(s1);
        cnf2 = cnfConverter.convertToCNF(s2);
        c1 = cnf1.getConjunctionOfClauses().get(0);
        c2 = cnf2.getConjunctionOfClauses().get(0);
        ClauseTest.assertTrue(c1.equals(c2));
        s1 = parser.parse("(((x1 = y1 AND y1 = z1) AND z1 = r1) => x1 = r1)");
        s2 = parser.parse("(((z2 = r2 AND y2 = z2) AND x2 = y2) => x2 = r2)");
        cnf1 = cnfConverter.convertToCNF(s1);
        cnf2 = cnfConverter.convertToCNF(s2);
        c1 = cnf1.getConjunctionOfClauses().get(0);
        c2 = cnf2.getConjunctionOfClauses().get(0);
        ClauseTest.assertTrue(c1.equals(c2));
        s1 = parser.parse("(((x1 = y1 AND y1 = z1) AND z1 = r1) => x1 = r1)");
        s2 = parser.parse("(((x2 = y2 AND y2 = z2) AND z2 = y2) => x2 = r2)");
        cnf1 = cnfConverter.convertToCNF(s1);
        cnf2 = cnfConverter.convertToCNF(s2);
        c1 = cnf1.getConjunctionOfClauses().get(0);
        c2 = cnf2.getConjunctionOfClauses().get(0);
        ClauseTest.assertFalse(c1.equals(c2));
        s1 = parser.parse("(((((x1 = y1 AND y1 = z1) AND z1 = r1) AND r1 = q1) AND q1 = s1) => x1 = r1)");
        s2 = parser.parse("(((((x2 = y2 AND y2 = z2) AND z2 = r2) AND r2 = q2) AND q2 = s2) => x2 = r2)");
        cnf1 = cnfConverter.convertToCNF(s1);
        cnf2 = cnfConverter.convertToCNF(s2);
        c1 = cnf1.getConjunctionOfClauses().get(0);
        c2 = cnf2.getConjunctionOfClauses().get(0);
        ClauseTest.assertTrue(c1.equals(c2));
        s1 = parser.parse("((((NOT(Animal(c1920)) OR NOT(Animal(c1921))) OR NOT(Kills(c1922,c1920))) OR NOT(Kills(c1919,c1921))) OR NOT(Kills(SF0(c1922),SF0(c1919))))");
        s2 = parser.parse("((((NOT(Animal(c1929)) OR NOT(Animal(c1928))) OR NOT(Kills(c1927,c1929))) OR NOT(Kills(c1930,c1928))) OR NOT(Kills(SF0(c1930),SF0(c1927))))");
        cnf1 = cnfConverter.convertToCNF(s1);
        cnf2 = cnfConverter.convertToCNF(s2);
        c1 = cnf1.getConjunctionOfClauses().get(0);
        c2 = cnf2.getConjunctionOfClauses().get(0);
        ClauseTest.assertTrue(c1.equals(c2));
    }

    public void testNonTrivialFactors() {
        FOLDomain domain = new FOLDomain();
        domain.addConstant("A");
        domain.addConstant("B");
        domain.addFunction("F");
        domain.addFunction("G");
        domain.addFunction("H");
        domain.addPredicate("P");
        domain.addPredicate("Q");
        FOLParser parser = new FOLParser(domain);
        Clause c = new Clause();
        c.addPositiveLiteral((Predicate)parser.parse("P(x,y)"));
        c.addPositiveLiteral((Predicate)parser.parse("Q(A,B)"));
        c.addNegativeLiteral((Predicate)parser.parse("P(B,A)"));
        c.addPositiveLiteral((Predicate)parser.parse("Q(y,x)"));
        ClauseTest.assertEquals("[[~P(B,A), P(B,A), Q(A,B)]]", c.getNonTrivialFactors().toString());
        c = new Clause();
        c.addPositiveLiteral((Predicate)parser.parse("P(x,y)"));
        c.addPositiveLiteral((Predicate)parser.parse("Q(A,B)"));
        c.addNegativeLiteral((Predicate)parser.parse("P(B,A)"));
        c.addNegativeLiteral((Predicate)parser.parse("Q(y,x)"));
        ClauseTest.assertEquals("[]", c.getNonTrivialFactors().toString());
        c = new Clause();
        c.addPositiveLiteral((Predicate)parser.parse("P(x,F(y))"));
        c.addPositiveLiteral((Predicate)parser.parse("P(G(u),x)"));
        c.addPositiveLiteral((Predicate)parser.parse("P(F(y),u)"));
        c = c.getNonTrivialFactors().iterator().next();
        Literal p = c.getPositiveLiterals().get(0);
        ClauseTest.assertEquals("P", p.getAtomicSentence().getSymbolicName());
        Function f = (Function)p.getAtomicSentence().getArgs().get(0);
        ClauseTest.assertEquals("F", f.getFunctionName());
        Variable v = (Variable)f.getTerms().get(0);
        f = (Function)p.getAtomicSentence().getArgs().get(1);
        ClauseTest.assertEquals("F", f.getFunctionName());
        ClauseTest.assertEquals(v, f.getTerms().get(0));
        p = c.getPositiveLiterals().get(1);
        f = (Function)p.getAtomicSentence().getArgs().get(0);
        ClauseTest.assertEquals("G", f.getFunctionName());
        f = (Function)f.getTerms().get(0);
        ClauseTest.assertEquals("F", f.getFunctionName());
        ClauseTest.assertEquals(v, f.getTerms().get(0));
        f = (Function)p.getAtomicSentence().getArgs().get(1);
        ClauseTest.assertEquals("F", f.getFunctionName());
        ClauseTest.assertEquals(v, f.getTerms().get(0));
        c = new Clause();
        c.addPositiveLiteral((Predicate)parser.parse("P(G(x))"));
        c.addPositiveLiteral((Predicate)parser.parse("Q(x)"));
        c.addPositiveLiteral((Predicate)parser.parse("P(F(A))"));
        c.addPositiveLiteral((Predicate)parser.parse("P(x)"));
        c.addPositiveLiteral((Predicate)parser.parse("P(G(F(x)))"));
        c.addPositiveLiteral((Predicate)parser.parse("Q(F(A))"));
        ClauseTest.assertEquals("[[P(F(A)), P(G(F(F(A)))), P(G(F(A))), Q(F(A))]]", c.getNonTrivialFactors().toString());
    }

    public void testIsTautology() {
        FOLDomain domain = new FOLDomain();
        domain.addConstant("A");
        domain.addPredicate("P");
        domain.addPredicate("Q");
        domain.addPredicate("R");
        domain.addFunction("F");
        FOLParser parser = new FOLParser(domain);
        Clause c = new Clause();
        c.addPositiveLiteral((Predicate)parser.parse("P(F(A))"));
        ClauseTest.assertFalse(c.isTautology());
        c.addNegativeLiteral((Predicate)parser.parse("P(F(A))"));
        ClauseTest.assertTrue(c.isTautology());
        c = new Clause();
        c.addPositiveLiteral((Predicate)parser.parse("P(x)"));
        ClauseTest.assertFalse(c.isTautology());
        c.addPositiveLiteral((Predicate)parser.parse("Q(y)"));
        ClauseTest.assertFalse(c.isTautology());
        c.addNegativeLiteral((Predicate)parser.parse("Q(y)"));
        ClauseTest.assertTrue(c.isTautology());
        c.addPositiveLiteral((Predicate)parser.parse("R(z)"));
        ClauseTest.assertTrue(c.isTautology());
        c = new Clause();
        c.addNegativeLiteral((Predicate)parser.parse("P(A)"));
        ClauseTest.assertFalse(c.isTautology());
        c.addPositiveLiteral((Predicate)parser.parse("P(x)"));
        ClauseTest.assertFalse(c.isTautology());
    }

    public void testSubsumes() {
        FOLDomain domain = new FOLDomain();
        domain.addConstant("A");
        domain.addConstant("B");
        domain.addConstant("C");
        domain.addConstant("D");
        domain.addConstant("E");
        domain.addConstant("F");
        domain.addConstant("G");
        domain.addConstant("H");
        domain.addConstant("I");
        domain.addConstant("J");
        domain.addPredicate("P");
        domain.addPredicate("Q");
        FOLParser parser = new FOLParser(domain);
        Clause psi = new Clause();
        psi.addNegativeLiteral((Predicate)parser.parse("P(A,B)"));
        psi.addPositiveLiteral((Predicate)parser.parse("Q(C)"));
        Clause phi = new Clause();
        phi.addNegativeLiteral((Predicate)parser.parse("P(x,y)"));
        ClauseTest.assertTrue(phi.subsumes(psi));
        psi = new Clause();
        psi.addNegativeLiteral((Predicate)parser.parse("P(x,B)"));
        psi.addPositiveLiteral((Predicate)parser.parse("Q(x)"));
        phi = new Clause();
        phi.addNegativeLiteral((Predicate)parser.parse("P(A,y)"));
        ClauseTest.assertFalse(phi.subsumes(psi));
        psi = new Clause();
        psi.addNegativeLiteral((Predicate)parser.parse("P(x,B)"));
        psi.addPositiveLiteral((Predicate)parser.parse("Q(z)"));
        phi = new Clause();
        phi.addNegativeLiteral((Predicate)parser.parse("P(A,y)"));
        ClauseTest.assertFalse(phi.subsumes(psi));
        psi = new Clause();
        psi.addNegativeLiteral((Predicate)parser.parse("P(A,B)"));
        psi.addNegativeLiteral((Predicate)parser.parse("P(w,z)"));
        psi.addPositiveLiteral((Predicate)parser.parse("Q(C)"));
        phi = new Clause();
        phi.addNegativeLiteral((Predicate)parser.parse("P(x,y)"));
        phi.addNegativeLiteral((Predicate)parser.parse("P(A,B)"));
        ClauseTest.assertTrue(phi.subsumes(psi));
        psi = new Clause();
        psi.addNegativeLiteral((Predicate)parser.parse("P(v,B)"));
        psi.addNegativeLiteral((Predicate)parser.parse("P(w,z)"));
        psi.addPositiveLiteral((Predicate)parser.parse("Q(C)"));
        phi = new Clause();
        phi.addNegativeLiteral((Predicate)parser.parse("P(x,y)"));
        phi.addNegativeLiteral((Predicate)parser.parse("P(A,B)"));
        ClauseTest.assertFalse(phi.subsumes(psi));
        psi = new Clause();
        psi.addNegativeLiteral((Predicate)parser.parse("P(A,B)"));
        psi.addNegativeLiteral((Predicate)parser.parse("P(C,D)"));
        psi.addNegativeLiteral((Predicate)parser.parse("P(E,F)"));
        psi.addNegativeLiteral((Predicate)parser.parse("P(G,H)"));
        psi.addNegativeLiteral((Predicate)parser.parse("P(I,J)"));
        psi.addPositiveLiteral((Predicate)parser.parse("Q(C)"));
        phi = new Clause();
        phi.addNegativeLiteral((Predicate)parser.parse("P(I,J)"));
        ClauseTest.assertTrue(phi.subsumes(psi));
        psi = new Clause();
        psi.addNegativeLiteral((Predicate)parser.parse("P(A,B)"));
        psi.addNegativeLiteral((Predicate)parser.parse("P(C,D)"));
        psi.addNegativeLiteral((Predicate)parser.parse("P(E,F)"));
        psi.addPositiveLiteral((Predicate)parser.parse("Q(C)"));
        phi = new Clause();
        phi.addNegativeLiteral((Predicate)parser.parse("P(E,F)"));
        phi.addNegativeLiteral((Predicate)parser.parse("P(A,B)"));
        phi.addNegativeLiteral((Predicate)parser.parse("P(C,D)"));
        ClauseTest.assertTrue(phi.subsumes(psi));
        psi = new Clause();
        psi.addNegativeLiteral((Predicate)parser.parse("P(A,B)"));
        psi.addNegativeLiteral((Predicate)parser.parse("P(C,D)"));
        psi.addNegativeLiteral((Predicate)parser.parse("P(E,F)"));
        psi.addNegativeLiteral((Predicate)parser.parse("P(G,H)"));
        psi.addNegativeLiteral((Predicate)parser.parse("P(I,J)"));
        psi.addPositiveLiteral((Predicate)parser.parse("Q(C)"));
        phi = new Clause();
        phi.addNegativeLiteral((Predicate)parser.parse("P(I,J)"));
        phi.addNegativeLiteral((Predicate)parser.parse("P(C,D)"));
        ClauseTest.assertTrue(phi.subsumes(psi));
        psi = new Clause();
        psi.addNegativeLiteral((Predicate)parser.parse("P(A,B)"));
        psi.addNegativeLiteral((Predicate)parser.parse("P(x,D)"));
        psi.addNegativeLiteral((Predicate)parser.parse("P(E,F)"));
        psi.addNegativeLiteral((Predicate)parser.parse("P(G,H)"));
        psi.addNegativeLiteral((Predicate)parser.parse("P(I,J)"));
        psi.addPositiveLiteral((Predicate)parser.parse("Q(C)"));
        phi = new Clause();
        phi.addNegativeLiteral((Predicate)parser.parse("P(I,J)"));
        phi.addNegativeLiteral((Predicate)parser.parse("P(C,D)"));
        ClauseTest.assertFalse(phi.subsumes(psi));
        psi = new Clause();
        psi.addNegativeLiteral((Predicate)parser.parse("P(A,B)"));
        psi.addNegativeLiteral((Predicate)parser.parse("P(C,D)"));
        psi.addNegativeLiteral((Predicate)parser.parse("P(E,F)"));
        psi.addNegativeLiteral((Predicate)parser.parse("P(G,H)"));
        psi.addNegativeLiteral((Predicate)parser.parse("P(I,J)"));
        psi.addPositiveLiteral((Predicate)parser.parse("Q(C)"));
        phi = new Clause();
        phi.addNegativeLiteral((Predicate)parser.parse("P(I,J)"));
        phi.addNegativeLiteral((Predicate)parser.parse("P(A,x)"));
        ClauseTest.assertTrue(phi.subsumes(psi));
        psi = new Clause();
        psi.addNegativeLiteral((Predicate)parser.parse("P(A,B)"));
        psi.addNegativeLiteral((Predicate)parser.parse("P(C,D)"));
        psi.addNegativeLiteral((Predicate)parser.parse("P(E,F)"));
        psi.addNegativeLiteral((Predicate)parser.parse("P(G,H)"));
        psi.addNegativeLiteral((Predicate)parser.parse("P(I,J)"));
        psi.addPositiveLiteral((Predicate)parser.parse("Q(A,B)"));
        psi.addPositiveLiteral((Predicate)parser.parse("Q(C,D)"));
        psi.addPositiveLiteral((Predicate)parser.parse("Q(E,F)"));
        phi = new Clause();
        phi.addNegativeLiteral((Predicate)parser.parse("P(I,J)"));
        phi.addNegativeLiteral((Predicate)parser.parse("P(A,B)"));
        phi.addPositiveLiteral((Predicate)parser.parse("Q(E,F)"));
        phi.addPositiveLiteral((Predicate)parser.parse("Q(A,B)"));
        ClauseTest.assertTrue(phi.subsumes(psi));
        psi = new Clause();
        psi.addNegativeLiteral((Predicate)parser.parse("P(A,B)"));
        psi.addNegativeLiteral((Predicate)parser.parse("P(C,D)"));
        psi.addNegativeLiteral((Predicate)parser.parse("P(E,F)"));
        psi.addNegativeLiteral((Predicate)parser.parse("P(G,H)"));
        psi.addNegativeLiteral((Predicate)parser.parse("P(I,J)"));
        psi.addPositiveLiteral((Predicate)parser.parse("Q(A,B)"));
        psi.addPositiveLiteral((Predicate)parser.parse("Q(C,D)"));
        psi.addPositiveLiteral((Predicate)parser.parse("Q(E,F)"));
        phi = new Clause();
        phi.addNegativeLiteral((Predicate)parser.parse("P(I,J)"));
        phi.addNegativeLiteral((Predicate)parser.parse("P(A,B)"));
        phi.addPositiveLiteral((Predicate)parser.parse("Q(E,A)"));
        phi.addPositiveLiteral((Predicate)parser.parse("Q(A,B)"));
        ClauseTest.assertFalse(phi.subsumes(psi));
    }
}

