/*
 * Decompiled with CFR 0.152.
 */
package aima.search.uninformed;

import aima.search.framework.Node;
import aima.search.framework.NodeExpander;
import aima.search.framework.Problem;
import aima.search.framework.Search;
import aima.search.framework.SearchUtils;
import java.util.ArrayList;
import java.util.List;

public class DepthLimitedSearch
extends NodeExpander
implements Search {
    private static String PATH_COST = "pathCost";
    private final int limit;

    public DepthLimitedSearch(int limit) {
        this.limit = limit;
    }

    @Override
    public List search(Problem p) throws Exception {
        this.clearInstrumentation();
        return this.recursiveDLS(new Node(p.getInitialState()), p, this.limit);
    }

    private List recursiveDLS(Node node, Problem problem, int limit) {
        boolean cutOffOccured = false;
        if (problem.isGoalState(node.getState())) {
            this.setPathCost(node.getPathCost());
            return SearchUtils.actionsFromNodes(node.getPathFromRoot());
        }
        if (node.getDepth() == limit) {
            return this.createCutOffResult();
        }
        List<Node> children = this.expandNode(node, problem);
        for (int i = 0; i < children.size(); ++i) {
            Node child = children.get(i);
            List result = this.recursiveDLS(child, problem, limit);
            if (this.cutoffResult(result)) {
                cutOffOccured = true;
                continue;
            }
            if (this.failure(result)) continue;
            return result;
        }
        if (cutOffOccured) {
            return this.createCutOffResult();
        }
        return new ArrayList();
    }

    @Override
    public void clearInstrumentation() {
        super.clearInstrumentation();
        this.metrics.set(PATH_COST, 0);
    }

    public double getPathCost() {
        return this.metrics.getDouble(PATH_COST);
    }

    public void setPathCost(Double pathCost) {
        this.metrics.set(PATH_COST, pathCost);
    }

    private boolean failure(List result) {
        return result.size() == 0;
    }

    private boolean cutoffResult(List result) {
        return result.size() == 1 && result.get(0).equals("cutoff");
    }

    private List createCutOffResult() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("cutoff");
        return result;
    }
}

