/*
 * Decompiled with CFR 0.152.
 */
package aima.probability.reasoning;

import aima.probability.RandomVariable;
import aima.probability.reasoning.HiddenMarkovModel;
import aima.probability.reasoning.SensorModel;
import aima.probability.reasoning.TransitionModel;
import java.util.Arrays;
import java.util.List;

public class HMMFactory {
    public static HiddenMarkovModel createRobotHMM() {
        List<String> states = Arrays.asList("open", "closed");
        List<String> actions2 = Arrays.asList("do_nothing", "push");
        List<String> perceptions = Arrays.asList("see_open", "see_closed");
        RandomVariable prior = new RandomVariable(states);
        TransitionModel tm = new TransitionModel(states, actions2);
        tm.setTransitionProbability("open", "do_nothing", "open", 1.0);
        tm.setTransitionProbability("open", "do_nothing", "open", 1.0);
        tm.setTransitionProbability("open", "do_nothing", "closed", 0.0);
        tm.setTransitionProbability("closed", "do_nothing", "closed", 1.0);
        tm.setTransitionProbability("closed", "do_nothing", "open", 0.0);
        tm.setTransitionProbability("open", "push", "open", 1.0);
        tm.setTransitionProbability("open", "push", "closed", 0.0);
        tm.setTransitionProbability("closed", "push", "closed", 0.2);
        tm.setTransitionProbability("closed", "push", "open", 0.8);
        SensorModel sm = new SensorModel(states, perceptions);
        sm.setSensingProbability("open", "see_closed", 0.4);
        sm.setSensingProbability("open", "see_open", 0.6);
        sm.setSensingProbability("closed", "see_open", 0.2);
        sm.setSensingProbability("closed", "see_closed", 0.8);
        HiddenMarkovModel hmm = new HiddenMarkovModel(prior, tm, sm);
        return hmm;
    }

    public static HiddenMarkovModel createRainmanHMM() {
        List<String> states = Arrays.asList("rain", "no_rain");
        List<String> perceptions = Arrays.asList("carries_umbrella", "does_not_carry_umbrella");
        RandomVariable prior = new RandomVariable(states);
        TransitionModel tm = new TransitionModel(states);
        tm.setTransitionProbability("rain", "rain", 0.7);
        tm.setTransitionProbability("rain", "no_rain", 0.3);
        tm.setTransitionProbability("no_rain", "rain", 0.3);
        tm.setTransitionProbability("no_rain", "no_rain", 0.7);
        SensorModel sm = new SensorModel(states, perceptions);
        sm.setSensingProbability("rain", "carries_umbrella", 0.9);
        sm.setSensingProbability("rain", "does_not_carry_umbrella", 0.1);
        sm.setSensingProbability("no_rain", "carries_umbrella", 0.2);
        sm.setSensingProbability("no_rain", "does_not_carry_umbrella", 0.8);
        HiddenMarkovModel hmm = new HiddenMarkovModel(prior, tm, sm);
        return hmm;
    }
}

