/*
 * Decompiled with CFR 0.152.
 */
package aima.probability;

import aima.probability.ProbabilityDistribution;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class BayesNetNode {
    private String variable;
    List<BayesNetNode> parents;
    List<BayesNetNode> children;
    ProbabilityDistribution distribution;

    public BayesNetNode(String variable) {
        this.variable = variable;
        this.parents = new ArrayList<BayesNetNode>();
        this.children = new ArrayList<BayesNetNode>();
        this.distribution = new ProbabilityDistribution(variable);
    }

    private void addParent(BayesNetNode node) {
        if (!this.parents.contains(node)) {
            this.parents.add(node);
        }
    }

    private void addChild(BayesNetNode node) {
        if (!this.children.contains(node)) {
            this.children.add(node);
        }
    }

    public void influencedBy(BayesNetNode parent1) {
        this.addParent(parent1);
        parent1.addChild(this);
        this.distribution = new ProbabilityDistribution(parent1.getVariable());
    }

    public void influencedBy(BayesNetNode parent1, BayesNetNode parent2) {
        this.influencedBy(parent1);
        this.influencedBy(parent2);
        this.distribution = new ProbabilityDistribution(parent1.getVariable(), parent2.getVariable());
    }

    public void setProbability(boolean b, double d) {
        this.distribution.set(b, d);
        if (this.isRoot()) {
            this.distribution.set(!b, 1.0 - d);
        }
    }

    private boolean isRoot() {
        return this.parents.size() == 0;
    }

    public void setProbability(boolean b, boolean c, double d) {
        this.distribution.set(b, c, d);
    }

    public String getVariable() {
        return this.variable;
    }

    public List<BayesNetNode> getChildren() {
        return this.children;
    }

    public List<BayesNetNode> getParents() {
        return this.parents;
    }

    public String toString() {
        return this.variable;
    }

    public double probabilityOf(Hashtable conditions) {
        return this.distribution.probabilityOf(conditions);
    }

    public Boolean isTrueFor(double probability, Hashtable<String, Boolean> modelBuiltUpSoFar) {
        Hashtable<String, Boolean> conditions = new Hashtable<String, Boolean>();
        if (this.isRoot()) {
            conditions.put(this.getVariable(), Boolean.TRUE);
        } else {
            for (int i = 0; i < this.parents.size(); ++i) {
                BayesNetNode parent = this.parents.get(i);
                conditions.put(parent.getVariable(), modelBuiltUpSoFar.get(parent.getVariable()));
            }
        }
        double trueProbability = this.probabilityOf(conditions);
        if (probability <= trueProbability) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BayesNetNode another = (BayesNetNode)o;
        return this.variable.equals(another.variable);
    }
}

