/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.propositional.algorithms;

import aima.logic.propositional.algorithms.Model;
import aima.logic.propositional.parsing.PEParser;
import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.parsing.ast.Symbol;
import aima.logic.propositional.visitors.CNFClauseGatherer;
import aima.logic.propositional.visitors.CNFTransformer;
import aima.logic.propositional.visitors.SymbolCollector;
import aima.util.Converter;
import aima.util.Util;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class WalkSAT {
    private Model myModel;
    private Random random = new Random();

    public Model findModelFor(String logicalSentence, int numberOfFlips, double probabilityOfRandomWalk) {
        this.myModel = new Model();
        Sentence s = (Sentence)new PEParser().parse(logicalSentence);
        CNFTransformer transformer = new CNFTransformer();
        CNFClauseGatherer clauseGatherer = new CNFClauseGatherer();
        SymbolCollector sc = new SymbolCollector();
        List<Symbol> symbols = new Converter<Symbol>().setToList(sc.getSymbolsIn(s));
        Random r = new Random();
        for (int i = 0; i < symbols.size(); ++i) {
            Symbol sym2 = symbols.get(i);
            this.myModel = this.myModel.extend(sym2, Util.randomBoolean());
        }
        List<Sentence> clauses = new Converter<Sentence>().setToList(clauseGatherer.getClausesFrom(transformer.transform(s)));
        for (int i = 0; i < numberOfFlips; ++i) {
            if (this.getNumberOfClausesSatisfiedIn(new Converter<Sentence>().listToSet(clauses), this.myModel) == clauses.size()) {
                return this.myModel;
            }
            Sentence clause = clauses.get(this.random.nextInt(clauses.size()));
            List<Symbol> symbolsInClause = new Converter<Symbol>().setToList(sc.getSymbolsIn(clause));
            if (this.random.nextDouble() >= probabilityOfRandomWalk) {
                Symbol randomSymbol = symbolsInClause.get(this.random.nextInt(symbolsInClause.size()));
                this.myModel = this.myModel.flip(randomSymbol);
                continue;
            }
            Symbol symbolToFlip = this.getSymbolWhoseFlipMaximisesSatisfiedClauses(new Converter<Sentence>().listToSet(clauses), symbolsInClause, this.myModel);
            this.myModel = this.myModel.flip(symbolToFlip);
        }
        return null;
    }

    private Symbol getSymbolWhoseFlipMaximisesSatisfiedClauses(Set<Sentence> clauses, List<Symbol> symbols, Model model) {
        if (symbols.size() > 0) {
            Symbol retVal = symbols.get(0);
            int maxClausesSatisfied = 0;
            for (int i = 0; i < symbols.size(); ++i) {
                Symbol sym2 = symbols.get(i);
                if (this.getNumberOfClausesSatisfiedIn(clauses, model.flip(sym2)) <= maxClausesSatisfied) continue;
                retVal = sym2;
                maxClausesSatisfied = this.getNumberOfClausesSatisfiedIn(clauses, model.flip(sym2));
            }
            return retVal;
        }
        return null;
    }

    private int getNumberOfClausesSatisfiedIn(Set clauses, Model model) {
        int retVal = 0;
        for (Sentence s : clauses) {
            if (!model.isTrue(s)) continue;
            ++retVal;
        }
        return retVal;
    }
}

