/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.propositional.algorithms;

import aima.logic.propositional.parsing.PLVisitor;
import aima.logic.propositional.parsing.ast.BinarySentence;
import aima.logic.propositional.parsing.ast.FalseSentence;
import aima.logic.propositional.parsing.ast.MultiSentence;
import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.parsing.ast.Symbol;
import aima.logic.propositional.parsing.ast.TrueSentence;
import aima.logic.propositional.parsing.ast.UnarySentence;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class Model
implements PLVisitor {
    Hashtable<String, Boolean> h = new Hashtable();

    public Boolean getStatus(Symbol symbol) {
        Boolean status = this.h.get(symbol.getValue());
        if (status != null) {
            return status;
        }
        return null;
    }

    public boolean isTrue(Symbol symbol) {
        Boolean status = this.h.get(symbol.getValue());
        if (status != null) {
            return status;
        }
        return false;
    }

    public boolean isFalse(Symbol symbol) {
        Boolean status = this.h.get(symbol.getValue());
        if (status != null) {
            return status == false;
        }
        return false;
    }

    private boolean isUnknown(Symbol s) {
        Boolean o = this.h.get(s.getValue());
        return o == null;
    }

    public Model extend(Symbol symbol, boolean b) {
        Model m = new Model();
        return this.extend(symbol.getValue(), b);
    }

    public Model extend(String s, boolean b) {
        Model m = new Model();
        for (String key : this.h.keySet()) {
            Boolean value = this.h.get(key);
            String newKey = new String(key.toCharArray());
            if (value == null) {
                throw new RuntimeException();
            }
            m.h.put(key, value);
        }
        m.h.put(s, new Boolean(b));
        return m;
    }

    public void print() {
        for (String key : this.h.keySet()) {
            Boolean value = this.h.get(key);
            System.out.print(key + " = " + value + " ");
        }
        System.out.println();
    }

    public boolean isTrue(Sentence clause) {
        Object result = clause.accept(this, null);
        return result == null ? false : (Boolean)result == true;
    }

    public boolean isFalse(Sentence clause) {
        Object o = clause.accept(this, null);
        return o != null ? !((Boolean)o).booleanValue() : false;
    }

    public boolean isUnknown(Sentence clause) {
        Object o = clause.accept(this, null);
        return o == null;
    }

    public Model flip(Symbol s) {
        if (this.isTrue(s)) {
            return this.extend(s, false);
        }
        if (this.isFalse(s)) {
            return this.extend(s, true);
        }
        return this;
    }

    public String toString() {
        return this.h.toString();
    }

    @Override
    public Object visitSymbol(Symbol s, Object arg) {
        return this.getStatus(s);
    }

    @Override
    public Object visitTrueSentence(TrueSentence ts, Object arg) {
        return Boolean.TRUE;
    }

    @Override
    public Object visitFalseSentence(FalseSentence fs, Object arg) {
        return Boolean.FALSE;
    }

    @Override
    public Object visitNotSentence(UnarySentence fs, Object arg) {
        Object negatedValue = fs.getNegated().accept(this, null);
        if (negatedValue != null) {
            return new Boolean((Boolean)negatedValue == false);
        }
        return null;
    }

    @Override
    public Object visitBinarySentence(BinarySentence bs, Object arg) {
        Object firstValue = bs.getFirst().accept(this, null);
        Object secondValue = bs.getSecond().accept(this, null);
        if (firstValue == null || secondValue == null) {
            return null;
        }
        String operator = bs.getOperator();
        if (operator.equals("AND")) {
            return this.evaluateAnd((Boolean)firstValue, (Boolean)secondValue);
        }
        if (operator.equals("OR")) {
            return this.evaluateOr((Boolean)firstValue, (Boolean)secondValue);
        }
        if (operator.equals("=>")) {
            return this.evaluateImplied((Boolean)firstValue, (Boolean)secondValue);
        }
        if (operator.equals("<=>")) {
            return this.evaluateBiConditional((Boolean)firstValue, (Boolean)secondValue);
        }
        return null;
    }

    @Override
    public Object visitMultiSentence(MultiSentence fs, Object argd) {
        return null;
    }

    private Boolean evaluateAnd(Boolean firstValue, Boolean secondValue) {
        if (firstValue.equals(Boolean.TRUE) && secondValue.equals(Boolean.TRUE)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Boolean evaluateOr(Boolean firstValue, Boolean secondValue) {
        if (firstValue.equals(Boolean.TRUE) || secondValue.equals(Boolean.TRUE)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Boolean evaluateImplied(Boolean firstValue, Boolean secondValue) {
        if (firstValue.equals(Boolean.TRUE) && secondValue.equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean evaluateBiConditional(Boolean firstValue, Boolean secondValue) {
        if (firstValue.equals(secondValue)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Set<Symbol> getAssignedSymbols() {
        HashSet<Symbol> set = new HashSet<Symbol>();
        Iterator<String> i = this.h.keySet().iterator();
        while (i.hasNext()) {
            Symbol key = new Symbol(i.next());
            if (this.isUnknown(key)) continue;
            set.add(key);
        }
        return set;
    }

    public boolean matches(String variable, boolean value) {
        if (value) {
            return this.isTrue(new Symbol(variable));
        }
        if (!value) {
            return this.isFalse(new Symbol(variable));
        }
        return false;
    }
}

