/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.neural;

import aima.learning.framework.DataSet;
import aima.learning.neural.FunctionApproximator;
import aima.learning.neural.Layer;
import aima.learning.neural.LogSigActivationFunction;
import aima.learning.neural.NNConfig;
import aima.learning.neural.NNDataSet;
import aima.learning.neural.NNExample;
import aima.learning.neural.NNTrainingScheme;
import aima.learning.neural.PureLinearActivationFunction;
import aima.learning.neural.Vector;
import aima.util.Matrix;

public class FeedForwardNeuralNetwork
implements FunctionApproximator {
    public static final String UPPER_LIMIT_WEIGHTS = "upper_limit_weights";
    public static final String LOWER_LIMIT_WEIGHTS = "lower_limit_weights";
    public static final String NUMBER_OF_OUTPUTS = "number_of_outputs";
    public static final String NUMBER_OF_HIDDEN_NEURONS = "number_of_hidden_neurons";
    public static final String NUMBER_OF_INPUTS = "number_of_inputs";
    private final Layer hiddenLayer;
    private final Layer outputLayer;
    private NNTrainingScheme trainingScheme;

    public FeedForwardNeuralNetwork(NNConfig config) {
        int numberOfInputNeurons = config.getParameterAsInteger(NUMBER_OF_INPUTS);
        int numberOfHiddenNeurons = config.getParameterAsInteger(NUMBER_OF_HIDDEN_NEURONS);
        int numberOfOutputNeurons = config.getParameterAsInteger(NUMBER_OF_OUTPUTS);
        double lowerLimitForWeights = config.getParameterAsDouble(LOWER_LIMIT_WEIGHTS);
        double upperLimitForWeights = config.getParameterAsDouble(UPPER_LIMIT_WEIGHTS);
        this.hiddenLayer = new Layer(numberOfHiddenNeurons, numberOfInputNeurons, lowerLimitForWeights, upperLimitForWeights, new LogSigActivationFunction());
        this.outputLayer = new Layer(numberOfOutputNeurons, numberOfHiddenNeurons, lowerLimitForWeights, upperLimitForWeights, new PureLinearActivationFunction());
    }

    public FeedForwardNeuralNetwork(Matrix hiddenLayerWeights, Vector hiddenLayerBias, Matrix outputLayerWeights, Vector outputLayerBias) {
        this.hiddenLayer = new Layer(hiddenLayerWeights, hiddenLayerBias, new LogSigActivationFunction());
        this.outputLayer = new Layer(outputLayerWeights, outputLayerBias, new PureLinearActivationFunction());
    }

    @Override
    public void processError(Vector error) {
        this.trainingScheme.processError(this, error);
    }

    @Override
    public Vector processInput(Vector input) {
        return this.trainingScheme.processInput(this, input);
    }

    public void trainOn(NNDataSet innds, int numberofEpochs) {
        for (int i = 0; i < numberofEpochs; ++i) {
            innds.refreshDataset();
            while (innds.hasMoreExamples()) {
                NNExample nne = innds.getExampleAtRandom();
                this.processInput(nne.getInput());
                Vector error = this.getOutputLayer().errorVectorFrom(nne.getTarget());
                this.processError(error);
            }
        }
    }

    public Vector predict(NNExample nne) {
        return this.processInput(nne.getInput());
    }

    public int[] testOnDataSet(NNDataSet nnds) {
        int[] result = new int[]{0, 0};
        nnds.refreshDataset();
        while (nnds.hasMoreExamples()) {
            Vector prediction;
            NNExample nne = nnds.getExampleAtRandom();
            if (nne.isCorrect(prediction = this.predict(nne))) {
                result[0] = result[0] + 1;
                continue;
            }
            result[1] = result[1] + 1;
        }
        return result;
    }

    public void testOn(DataSet ds) {
    }

    public Matrix getHiddenLayerWeights() {
        return this.hiddenLayer.getWeightMatrix();
    }

    public Vector getHiddenLayerBias() {
        return this.hiddenLayer.getBiasVector();
    }

    public Matrix getOutputLayerWeights() {
        return this.outputLayer.getWeightMatrix();
    }

    public Vector getOutputLayerBias() {
        return this.outputLayer.getBiasVector();
    }

    public Layer getHiddenLayer() {
        return this.hiddenLayer;
    }

    public Layer getOutputLayer() {
        return this.outputLayer;
    }

    public void setTrainingScheme(NNTrainingScheme trainingScheme) {
        this.trainingScheme = trainingScheme;
        trainingScheme.setNeuralNetwork(this);
    }
}

