/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.learners;

import aima.learning.framework.DataSet;
import aima.learning.framework.Example;
import aima.learning.framework.Learner;
import aima.learning.inductive.DLTest;
import aima.learning.inductive.DLTestFactory;
import aima.learning.inductive.DecisionList;
import java.util.List;

public class DecisionListLearner
implements Learner {
    public static final String FAILURE = "Failure";
    private DecisionList decisionList;
    private String positive;
    private String negative;
    private DLTestFactory testFactory;

    public DecisionListLearner(String positive, String negative, DLTestFactory testFactory) {
        this.positive = positive;
        this.negative = negative;
        this.testFactory = testFactory;
    }

    @Override
    public void train(DataSet ds) {
        this.decisionList = this.decisionListLearning(ds);
    }

    @Override
    public String predict(Example e) {
        if (this.decisionList == null) {
            throw new RuntimeException("learner has not been trained with dataset yet!");
        }
        return this.decisionList.predict(e);
    }

    @Override
    public int[] test(DataSet ds) {
        int[] results = new int[]{0, 0};
        for (Example e : ds.examples) {
            if (e.targetValue().equals(this.decisionList.predict(e))) {
                results[0] = results[0] + 1;
                continue;
            }
            results[1] = results[1] + 1;
        }
        return results;
    }

    private DecisionList decisionListLearning(DataSet ds) {
        if (ds.size() == 0) {
            return new DecisionList(this.positive, this.negative);
        }
        List<DLTest> possibleTests = this.testFactory.createDLTestsWithAttributeCount(ds, 1);
        DLTest test = this.getValidTest(possibleTests, ds);
        if (test == null) {
            return new DecisionList(null, FAILURE);
        }
        DataSet matched = test.matchedExamples(ds);
        DecisionList list = new DecisionList(this.positive, this.negative);
        list.add(test, matched.getExample(0).targetValue());
        return list.mergeWith(this.decisionListLearning(test.unmatchedExamples(ds)));
    }

    private DLTest getValidTest(List<DLTest> possibleTests, DataSet ds) {
        for (DLTest test : possibleTests) {
            DataSet matched = test.matchedExamples(ds);
            if (matched.size() == 0 || !this.allExamplesHaveSameTargetValue(matched)) continue;
            return test;
        }
        return null;
    }

    private boolean allExamplesHaveSameTargetValue(DataSet matched) {
        String targetValue = matched.getExample(0).targetValue();
        for (Example e : matched.examples) {
            if (e.targetValue().equals(targetValue)) continue;
            return false;
        }
        return true;
    }

    public DecisionList getDecisionList() {
        return this.decisionList;
    }
}

