/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.knowledge;

import aima.learning.framework.Example;
import aima.learning.knowledge.FOLDataSetDomain;
import aima.logic.fol.parsing.ast.ConnectedSentence;
import aima.logic.fol.parsing.ast.Constant;
import aima.logic.fol.parsing.ast.NotSentence;
import aima.logic.fol.parsing.ast.Predicate;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.Term;
import java.util.ArrayList;

public class FOLExample {
    private FOLDataSetDomain folDSDomain = null;
    private Example example = null;
    private int egNo = 0;
    private Constant ithExampleConstant = null;
    private Sentence classification = null;
    private Sentence description = null;

    public FOLExample(FOLDataSetDomain folDSDomain, Example example, int egNo) {
        this.folDSDomain = folDSDomain;
        this.example = example;
        this.egNo = egNo;
        this.constructFOLEg();
    }

    public int getExampleNumber() {
        return this.egNo;
    }

    public Sentence getClassification() {
        return this.classification;
    }

    public Sentence getDescription() {
        return this.description;
    }

    public String toString() {
        return this.classification.toString() + " " + "AND" + " " + this.description.toString();
    }

    private void constructFOLEg() {
        this.ithExampleConstant = new Constant(this.folDSDomain.getExampleConstant(this.egNo));
        ArrayList<Term> terms = new ArrayList<Term>();
        terms.add(this.ithExampleConstant);
        this.classification = new Predicate(this.folDSDomain.getGoalPredicateName(), terms);
        if (!this.example.getAttributeValueAsString(this.folDSDomain.getDataSetTargetName()).equals(this.folDSDomain.getTrueGoalValue())) {
            this.classification = new NotSentence(this.classification);
        }
        ArrayList<Predicate> descParts = new ArrayList<Predicate>();
        for (String dname : this.folDSDomain.getDescriptionDataSetNames()) {
            String foldDName = this.folDSDomain.getFOLName(dname);
            terms = new ArrayList();
            terms.add(this.ithExampleConstant);
            Sentence part = null;
            if (this.folDSDomain.isMultivalued(dname)) {
                terms.add(new Constant(this.folDSDomain.getFOLName(this.example.getAttributeValueAsString(dname))));
                part = new Predicate(foldDName, terms);
            } else {
                part = new Predicate(foldDName, terms);
                if (!this.folDSDomain.getTrueGoalValue().equals(this.example.getAttributeValueAsString(dname))) {
                    part = new NotSentence(part);
                }
            }
            descParts.add((Predicate)part);
        }
        if (descParts.size() == 1) {
            this.description = (Sentence)descParts.get(0);
        } else if (descParts.size() > 1) {
            this.description = new ConnectedSentence("AND", (Sentence)descParts.get(0), (Sentence)descParts.get(1));
            for (int i = 2; i < descParts.size(); ++i) {
                this.description = new ConnectedSentence("AND", this.description, (Sentence)descParts.get(i));
            }
        }
    }
}

