/*
 * Decompiled with CFR 0.152.
 */
package aima.gui.framework;

import aima.gui.framework.AgentAppFrame;
import aima.gui.framework.AgentAppModel;
import aima.search.map.Point2D;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class AgentView
extends AgentAppFrame.AbstractAgentView {
    protected AgentAppModel model;
    private int borderTop = 10;
    private int borderLeft = 10;
    private int borderBottom = 10;
    private int borderRight = 10;
    private double offsetX;
    private double offsetY;
    private double scale;

    public void setBorder(int top, int left, int bottom, int right) {
        this.borderTop = top;
        this.borderLeft = left;
        this.borderBottom = bottom;
        this.borderRight = right;
    }

    public void adjustTransformation(double minXW, double minYW, double maxXW, double maxYW) {
        double scaleX = 1.0;
        double scaleY = 1.0;
        if (maxXW > minXW) {
            scaleX = (double)(this.getWidth() - this.borderLeft - this.borderRight) / (maxXW - minXW);
        }
        if (maxYW > minYW) {
            scaleY = (double)(this.getHeight() - this.borderTop - this.borderBottom) / (maxYW - minYW);
        }
        this.offsetX = -minXW;
        this.offsetY = -minYW;
        this.scale = Math.min(scaleX, scaleY);
    }

    protected int x(Point2D xyW) {
        return this.x(xyW.getX());
    }

    protected int y(Point2D xyW) {
        return this.y(xyW.getY());
    }

    protected int x(double xW) {
        return (int)Math.round(this.scale * (xW + this.offsetX) + (double)this.borderLeft);
    }

    protected int y(double yW) {
        return (int)Math.round(this.scale * (yW + this.offsetY) + (double)this.borderTop);
    }

    protected int scale(int length) {
        return (int)Math.round(this.scale * (double)length);
    }

    @Override
    public void updateView(AgentAppModel model) {
        this.model = model;
        if (model != null) {
            this.repaint();
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setBackground(Color.white);
        g2.clearRect(0, 0, this.getWidth(), this.getHeight());
    }
}

