/*
 * Decompiled with CFR 0.152.
 */
package aima.gui.applications.search.map;

import aima.basic.Agent;
import aima.gui.applications.search.map.MapAgentFrame;
import aima.gui.applications.search.map.MapAgentModel;
import aima.gui.framework.AgentAppController;
import aima.gui.framework.AgentAppFrame;
import aima.search.framework.Search;
import aima.search.framework.SearchFactory;
import aima.search.map.AdaptableHeuristicFunction;
import aima.search.map.Scenario;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractMapAgentController
extends AgentAppController {
    protected Scenario scenario;
    protected List<String> destinations;
    protected Search search;
    protected AdaptableHeuristicFunction heuristic;

    @Override
    public void clearAgent() {
        ((MapAgentModel)this.model).clearTourHistory();
        this.frame.modelChanged();
    }

    @Override
    public void prepareAgent() {
        AgentAppFrame.SelectionState state = this.frame.getSelection();
        this.selectScenarioAndDest(state.getValue(MapAgentFrame.SCENARIO_SEL), state.getValue(MapAgentFrame.DESTINATION_SEL));
        this.prepareModel();
        this.search = SearchFactory.getInstance().createSearch(state.getValue(MapAgentFrame.SEARCH_SEL), state.getValue(MapAgentFrame.SEARCH_MODE_SEL));
        this.heuristic = this.createHeuristic(state.getValue(MapAgentFrame.HEURISTIC_SEL));
        this.scenario.getEnv().registerView(this.model);
    }

    @Override
    public void runAgent() {
        this.startAgent();
        ArrayList agents = this.scenario.getEnv().getAgents();
        if (agents.size() == 1) {
            Agent agent = (Agent)agents.get(0);
            String status = (String)agent.getAttribute("status");
            Double travelDistance = (Double)agent.getAttribute("travelDistance");
            StringBuffer statusMsg = new StringBuffer();
            if (status != null) {
                statusMsg.append("Agent status: " + status);
            } else {
                statusMsg.append("Task completed");
            }
            if (travelDistance != null) {
                DecimalFormat f = new DecimalFormat("#0.0");
                statusMsg.append("; travel distance: " + f.format(travelDistance));
            }
            statusMsg.append(".");
            this.frame.setStatus(statusMsg.toString());
        }
    }

    protected abstract void selectScenarioAndDest(int var1, int var2);

    protected abstract void prepareModel();

    protected abstract AdaptableHeuristicFunction createHeuristic(int var1);

    protected abstract void startAgent();
}

