/*
 * Decompiled with CFR 0.152.
 */
package aima.basic;

import aima.basic.Agent;
import aima.basic.Environment;
import aima.basic.EnvironmentObject;
import aima.basic.ObjectWithDynamicAttributes;
import aima.basic.Percept;
import aima.basic.Wall;
import aima.basic.XYLocation;
import aima.util.Calculator;
import java.util.ArrayList;
import java.util.List;

public class XYEnvironment
extends Environment {
    public static String LOCATION = "location";
    int width;
    int height;
    XYLocation defaultLocation;

    public XYEnvironment() {
    }

    public XYEnvironment(int width, int height) {
        this.width = width;
        this.height = height;
        this.defaultLocation = new XYLocation(1, 1);
    }

    public void addObject(EnvironmentObject o, XYLocation loc) {
        super.addObject(o, LOCATION, loc);
    }

    public void addAgent(Agent a, XYLocation loc) {
        super.addAgent(a, LOCATION, loc);
    }

    public void moveObjectToAbsoluteLocation(Agent a, XYLocation loc) {
        a.setAttribute(LOCATION, loc);
    }

    public void moveObject(Agent a, String direction) {
        XYLocation presentLocation = (XYLocation)a.getAttribute(LOCATION);
        XYLocation locationToMoveTo = presentLocation.locationAt(direction);
        if (!this.isBlocked(locationToMoveTo)) {
            this.moveObjectToAbsoluteLocation(a, locationToMoveTo);
        }
    }

    public ArrayList<ObjectWithDynamicAttributes> getObjectsAt(XYLocation loc) {
        ArrayList<ObjectWithDynamicAttributes> retval = new ArrayList<ObjectWithDynamicAttributes>();
        List<ObjectWithDynamicAttributes> all = this.getAllObjects();
        for (ObjectWithDynamicAttributes obj : all) {
            XYLocation objLoc = (XYLocation)obj.getAttribute(LOCATION);
            if (!objLoc.equals(loc)) continue;
            retval.add(obj);
        }
        return retval;
    }

    public ArrayList getObjectsNear(Agent agent, int radius) {
        ArrayList<ObjectWithDynamicAttributes> retval = new ArrayList<ObjectWithDynamicAttributes>();
        XYLocation agentLocation = (XYLocation)agent.getAttribute(LOCATION);
        List<ObjectWithDynamicAttributes> all = this.getAllObjects();
        for (ObjectWithDynamicAttributes a : all) {
            XYLocation otherAgentLocation;
            if (a.equals(agent) || !this.withinRadius(radius, agentLocation, otherAgentLocation = (XYLocation)a.getAttribute(LOCATION))) continue;
            retval.add(a);
        }
        return retval;
    }

    private boolean withinRadius(int radius, XYLocation agentLocation, XYLocation objectLocation) {
        int radiusSquared;
        int dist = Calculator.calculateSquareOfDistanceBetweenLocations(agentLocation, objectLocation);
        boolean withinRadius = dist <= (radiusSquared = radius * radius);
        return withinRadius;
    }

    @Override
    public void executeAction(Agent a, String Action2) {
    }

    @Override
    public Percept getPerceptSeenBy(Agent anAgent) {
        return new Percept();
    }

    public boolean isBlocked(XYLocation loc) {
        boolean retval = false;
        ArrayList<ObjectWithDynamicAttributes> objs = this.getObjectsAt(loc);
        for (ObjectWithDynamicAttributes o : objs) {
            if (!(o instanceof Wall)) continue;
            retval = true;
        }
        return retval;
    }

    public void makePerimeter() {
        XYLocation loc2;
        XYLocation loc;
        int i;
        for (i = 0; i < this.width; ++i) {
            loc = new XYLocation(i, 0);
            loc2 = new XYLocation(i, this.height - 1);
            this.addObject(new Wall(), loc);
            this.addObject(new Wall(), loc2);
        }
        for (i = 0; i < this.height; ++i) {
            loc = new XYLocation(0, i);
            loc2 = new XYLocation(this.width - 1, i);
            this.addObject(new Wall(), loc);
            this.addObject(new Wall(), loc2);
        }
    }
}

