/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.Iterator;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.OptionalExpression;
import org.datanucleus.store.types.ContainerAdapter;
import org.datanucleus.store.types.TypeManager;

public class OptionalLiteral
extends OptionalExpression {
    private Object value;

    public OptionalLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value, String parameterName) {
        super(stmt, null, mapping);
        this.value = value;
        TypeManager typeManager = mapping.getStoreManager().getNucleusContext().getTypeManager();
        ContainerAdapter containerAdapter = typeManager.getContainerAdapter(value);
        Iterator iterator = containerAdapter.iterator();
        if (iterator.hasNext()) {
            Object wrappedValue = iterator.next();
            JavaTypeMapping m = stmt.getRDBMSManager().getSQLExpressionFactory().getMappingForType(wrappedValue.getClass(), false);
            this.delegate = stmt.getSQLExpressionFactory().newLiteral(stmt, m, wrappedValue);
        } else {
            this.delegate = new NullLiteral(stmt, null, null, null);
        }
    }

    public Object getValue() {
        return this.value;
    }

    public void setNotParameter() {
        throw new NucleusException("Not implemented yet.");
    }
}

