/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.datastore;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.exceptions.NullValueException;
import org.datanucleus.store.rdbms.mapping.datastore.AbstractDatastoreMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.Localiser;

public class DecimalRDBMSMapping
extends AbstractDatastoreMapping {
    private static final int INT_MAX_DECIMAL_DIGITS = 10;
    private static final int LONG_MAX_DECIMAL_DIGITS = 19;

    public DecimalRDBMSMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(storeMgr, mapping);
        this.column = col;
        this.initialize();
    }

    private void initialize() {
        if (this.column != null && this.column.getColumnMetaData().getLength() == null) {
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_INTEGER)) {
                this.column.getColumnMetaData().setLength(Integer.valueOf(10));
                this.column.checkDecimal();
            } else {
                this.column.getColumnMetaData().setLength(Integer.valueOf(Math.min(this.getTypeInfo().getPrecision(), 19)));
                this.column.checkDecimal();
            }
        }
        this.initTypeInfo();
    }

    @Override
    public boolean isDecimalBased() {
        return true;
    }

    @Override
    public int getJDBCType() {
        return 3;
    }

    @Override
    public void setDouble(PreparedStatement ps, int param, double value) {
        try {
            ps.setDouble(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"double", "" + value, this.column, e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public void setFloat(PreparedStatement ps, int param, float value) {
        try {
            ps.setDouble(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"float", "" + value, this.column, e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public void setInt(PreparedStatement ps, int param, int value) {
        try {
            ps.setInt(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"int", "" + value, this.column, e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public double getDouble(ResultSet rs, int param) {
        double value;
        try {
            value = rs.getDouble(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && rs.wasNull()) {
                throw new NullValueException(Localiser.msg((String)"055003", (Object[])new Object[]{this.column}));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"double", "" + param, this.column, e.getMessage()}), (Throwable)e);
        }
        return value;
    }

    @Override
    public float getFloat(ResultSet rs, int param) {
        float value;
        try {
            value = (float)rs.getDouble(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && rs.wasNull()) {
                throw new NullValueException(Localiser.msg((String)"055003", (Object[])new Object[]{this.column}));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"float", "" + param, this.column, e.getMessage()}), (Throwable)e);
        }
        return value;
    }

    @Override
    public int getInt(ResultSet rs, int param) {
        int value;
        try {
            value = rs.getInt(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && rs.wasNull()) {
                throw new NullValueException(Localiser.msg((String)"055003", (Object[])new Object[]{this.column}));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"int", "" + param, this.column, e.getMessage()}), (Throwable)e);
        }
        return value;
    }

    @Override
    public void setLong(PreparedStatement ps, int param, long value) {
        try {
            ps.setLong(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"long", "" + value, this.column, e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public long getLong(ResultSet rs, int param) {
        long value;
        try {
            value = rs.getLong(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && rs.wasNull()) {
                throw new NullValueException(Localiser.msg((String)"055003", (Object[])new Object[]{this.column}));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"long", "" + param, this.column, e.getMessage()}), (Throwable)e);
        }
        return value;
    }

    @Override
    public void setObject(PreparedStatement ps, int param, Object value) {
        try {
            if (value == null) {
                if (this.useDefaultWhenNull()) {
                    ps.setInt(param, Integer.valueOf(this.column.getDefaultValue().toString()));
                } else {
                    ps.setNull(param, this.getJDBCType());
                }
            } else if (value instanceof Integer) {
                ps.setBigDecimal(param, BigDecimal.valueOf(((Integer)value).longValue()));
            } else if (value instanceof Long) {
                ps.setBigDecimal(param, new BigDecimal((Long)value));
            } else if (value instanceof BigDecimal) {
                ps.setBigDecimal(param, (BigDecimal)value);
            } else if (value instanceof Float) {
                ps.setDouble(param, ((Float)value).doubleValue());
            } else if (value instanceof Double) {
                ps.setDouble(param, (Double)value);
            } else if (value instanceof BigInteger) {
                ps.setBigDecimal(param, new BigDecimal((BigInteger)value));
            } else {
                ps.setInt(param, ((Number)value).intValue());
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"Object", "" + value, this.column, e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public Object getObject(ResultSet rs, int param) {
        Number value;
        try {
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_INTEGER)) {
                value = rs.getBigDecimal(param);
                value = value == null ? null : Integer.valueOf(value.toBigInteger().intValue());
            } else if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_LONG)) {
                value = rs.getBigDecimal(param);
                value = value == null ? null : Long.valueOf(value.toBigInteger().longValue());
            } else if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_MATH_BIGINTEGER)) {
                value = rs.getBigDecimal(param);
                value = value == null ? null : value.toBigInteger();
            } else if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_MATH_BIGDECIMAL)) {
                value = rs.getBigDecimal(param);
            } else if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_FLOAT)) {
                double d = rs.getDouble(param);
                value = rs.wasNull() ? null : Float.valueOf((float)d);
            } else if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_DOUBLE)) {
                double d = rs.getDouble(param);
                value = rs.wasNull() ? null : Double.valueOf(d);
            } else {
                int i = rs.getInt(param);
                value = rs.wasNull() ? null : Integer.valueOf(i);
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"Object", "" + param, this.column, e.getMessage()}), (Throwable)e);
        }
        return value;
    }
}

