/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.AbstractSelectStatementGenerator;
import org.datanucleus.store.rdbms.sql.SQLJoin;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.schema.table.SurrogateColumnType;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class UnionStatementGenerator
extends AbstractSelectStatementGenerator {
    public static final String DN_TYPE_COLUMN = "DN_TYPE";
    private int maxClassNameLength = -1;

    public UnionStatementGenerator(RDBMSStoreManager storeMgr, ClassLoaderResolver clr, Class candidateType, boolean includeSubclasses, DatastoreIdentifier candidateTableAlias, String candidateTableGroupName) {
        super(storeMgr, clr, candidateType, includeSubclasses, candidateTableAlias, candidateTableGroupName);
    }

    public UnionStatementGenerator(RDBMSStoreManager storeMgr, ClassLoaderResolver clr, Class candidateType, boolean includeSubclasses, DatastoreIdentifier candidateTableAlias, String candidateTableGroupName, Table joinTable, DatastoreIdentifier joinTableAlias, JavaTypeMapping joinElementMapping) {
        super(storeMgr, clr, candidateType, includeSubclasses, candidateTableAlias, candidateTableGroupName, joinTable, joinTableAlias, joinElementMapping);
    }

    @Override
    public void setParentStatement(SQLStatement stmt) {
        this.parentStmt = stmt;
    }

    @Override
    public SelectStatement getStatement(ExecutionContext ec) {
        ArrayList<String> candidateClassNames = new ArrayList<String>();
        AbstractClassMetaData acmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(this.candidateType, this.clr);
        candidateClassNames.add(acmd.getFullClassName());
        if (this.includeSubclasses) {
            Collection subclasses = this.storeMgr.getSubClassesForClass(this.candidateType.getName(), true, this.clr);
            candidateClassNames.addAll(subclasses);
        }
        Iterator iter = candidateClassNames.iterator();
        while (iter.hasNext()) {
            String className = (String)iter.next();
            try {
                Class cls = this.clr.classForName(className);
                if (!Modifier.isAbstract(cls.getModifiers())) continue;
                iter.remove();
            }
            catch (Exception e) {
                iter.remove();
            }
        }
        if (this.hasOption("selectDnType")) {
            for (String className : candidateClassNames) {
                if (className.length() <= this.maxClassNameLength) continue;
                this.maxClassNameLength = className.length();
            }
        }
        if (candidateClassNames.isEmpty()) {
            throw new NucleusException("Attempt to generate SQL statement using UNIONs for " + this.candidateType.getName() + " yet there are no concrete classes with their own table available");
        }
        SelectStatement stmt = null;
        for (String candidateClassName : candidateClassNames) {
            SelectStatement candidateStmt = null;
            candidateStmt = this.joinTable == null ? this.getSelectStatementForCandidate(candidateClassName, ec) : this.getSQLStatementForCandidateViaJoin(candidateClassName);
            if (candidateStmt == null) continue;
            if (stmt == null) {
                stmt = candidateStmt;
                continue;
            }
            stmt.union(candidateStmt);
        }
        return stmt;
    }

    protected SelectStatement getSelectStatementForCandidate(String className, ExecutionContext ec) {
        JavaTypeMapping softDeleteMapping;
        JavaTypeMapping multitenancyMapping;
        DatastoreClass table = this.storeMgr.getDatastoreClass(className, this.clr);
        if (table == null) {
            NucleusLogger.GENERAL.info((Object)("Generation of statement to retrieve objects of type " + this.candidateType.getName() + (this.includeSubclasses ? " including subclasses " : "") + " attempted to include " + className + " but this has no table of its own; ignored"));
            return null;
        }
        SelectStatement stmt = new SelectStatement(this.parentStmt, this.storeMgr, this.candidateTable, this.candidateTableAlias, this.candidateTableGroupName);
        stmt.setClassLoaderResolver(this.clr);
        stmt.setCandidateClassName(className);
        String tblGroupName = stmt.getPrimaryTable().getGroupName();
        if (table != this.candidateTable) {
            JavaTypeMapping candidateIdMapping = this.candidateTable.getIdMapping();
            JavaTypeMapping tableIdMapping = table.getIdMapping();
            SQLTable tableSqlTbl = stmt.join(SQLJoin.JoinType.INNER_JOIN, null, candidateIdMapping, (Table)table, null, tableIdMapping, null, stmt.getPrimaryTable().getGroupName(), true);
            tblGroupName = tableSqlTbl.getGroupName();
        }
        SQLExpressionFactory factory = this.storeMgr.getSQLExpressionFactory();
        JavaTypeMapping discriminatorMapping = table.getSurrogateMapping(SurrogateColumnType.DISCRIMINATOR, false);
        DiscriminatorMetaData discriminatorMetaData = table.getDiscriminatorMetaData();
        if (discriminatorMapping != null && discriminatorMetaData.getStrategy() != DiscriminatorStrategy.NONE) {
            AbstractClassMetaData targetCmd = this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(className, this.clr);
            SQLExpression discExpr = factory.newExpression(stmt, stmt.getPrimaryTable(), discriminatorMapping);
            SQLExpression discValExpr = factory.newLiteral(stmt, discriminatorMapping, targetCmd.getDiscriminatorValue());
            stmt.whereAnd(discExpr.eq(discValExpr), false);
        }
        if ((multitenancyMapping = table.getSurrogateMapping(SurrogateColumnType.MULTITENANCY, false)) != null) {
            AbstractClassMetaData cmd = table.getClassMetaData();
            SQLTable tenantSqlTbl = stmt.getTable(multitenancyMapping.getTable(), tblGroupName);
            SQLExpression tenantExpr = stmt.getSQLExpressionFactory().newExpression(stmt, tenantSqlTbl, multitenancyMapping);
            SQLExpression tenantVal = stmt.getSQLExpressionFactory().newLiteral(stmt, multitenancyMapping, ec.getNucleusContext().getMultiTenancyId(ec, cmd));
            stmt.whereAnd(tenantExpr.eq(tenantVal), true);
        }
        if ((softDeleteMapping = table.getSurrogateMapping(SurrogateColumnType.SOFTDELETE, false)) != null && !this.hasOption("includeSoftDeletes")) {
            SQLTable softDeleteSqlTbl = stmt.getTable(softDeleteMapping.getTable(), tblGroupName);
            SQLExpression softDeleteExpr = stmt.getSQLExpressionFactory().newExpression(stmt, softDeleteSqlTbl, softDeleteMapping);
            SQLExpression softDeleteVal = stmt.getSQLExpressionFactory().newLiteral(stmt, softDeleteMapping, Boolean.FALSE);
            stmt.whereAnd(softDeleteExpr.eq(softDeleteVal), true);
        }
        for (String subclassName : this.storeMgr.getSubClassesForClass(className, false, this.clr)) {
            DatastoreClass[] subclassTables = null;
            DatastoreClass subclassTable = this.storeMgr.getDatastoreClass(subclassName, this.clr);
            if (subclassTable == null) {
                AbstractClassMetaData targetSubCmd = this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(subclassName, this.clr);
                AbstractClassMetaData[] targetSubCmds = this.storeMgr.getClassesManagingTableForClass(targetSubCmd, this.clr);
                subclassTables = new DatastoreClass[targetSubCmds.length];
                for (int i = 0; i < targetSubCmds.length; ++i) {
                    subclassTables[i] = this.storeMgr.getDatastoreClass(targetSubCmds[i].getFullClassName(), this.clr);
                }
            } else {
                subclassTables = new DatastoreClass[]{subclassTable};
            }
            for (int i = 0; i < subclassTables.length; ++i) {
                if (subclassTables[i] == table) continue;
                JavaTypeMapping tableIdMapping = table.getIdMapping();
                JavaTypeMapping subclassIdMapping = subclassTables[i].getIdMapping();
                SQLTable sqlTableSubclass = stmt.join(SQLJoin.JoinType.LEFT_OUTER_JOIN, null, tableIdMapping, (Table)subclassTables[i], null, subclassIdMapping, null, stmt.getPrimaryTable().getGroupName(), true);
                SQLExpression subclassIdExpr = factory.newExpression(stmt, sqlTableSubclass, subclassIdMapping);
                NullLiteral nullExpr = new NullLiteral(stmt, null, null, null);
                stmt.whereAnd(subclassIdExpr.eq(nullExpr), false);
            }
        }
        if (this.hasOption("selectDnType")) {
            this.addTypeSelectForClass(stmt, className);
        }
        return stmt;
    }

    protected SelectStatement getSQLStatementForCandidateViaJoin(String className) {
        JavaTypeMapping candidateIdMapping;
        DatastoreClass table = this.storeMgr.getDatastoreClass(className, this.clr);
        if (table == null) {
            throw new NucleusException("We do not currently support a UNION statement for class=" + className + " since it has no table of its own");
        }
        SelectStatement stmt = new SelectStatement(this.parentStmt, this.storeMgr, this.joinTable, this.joinTableAlias, this.candidateTableGroupName);
        stmt.setClassLoaderResolver(this.clr);
        stmt.setCandidateClassName(className);
        SQLTable candidateSQLTable = null;
        if (this.candidateTable != null) {
            candidateIdMapping = this.candidateTable.getIdMapping();
            candidateSQLTable = this.hasOption("allowNulls") ? stmt.join(SQLJoin.JoinType.LEFT_OUTER_JOIN, null, this.joinElementMapping, (Table)this.candidateTable, null, candidateIdMapping, null, stmt.getPrimaryTable().getGroupName(), true) : stmt.join(SQLJoin.JoinType.INNER_JOIN, null, this.joinElementMapping, (Table)this.candidateTable, null, candidateIdMapping, null, stmt.getPrimaryTable().getGroupName(), true);
            if (table != this.candidateTable) {
                stmt.join(SQLJoin.JoinType.INNER_JOIN, candidateSQLTable, candidateIdMapping, (Table)table, null, table.getIdMapping(), null, stmt.getPrimaryTable().getGroupName(), true);
            }
        } else {
            candidateIdMapping = table.getIdMapping();
            candidateSQLTable = this.hasOption("allowNulls") ? stmt.join(SQLJoin.JoinType.LEFT_OUTER_JOIN, null, this.joinElementMapping, (Table)table, null, candidateIdMapping, null, stmt.getPrimaryTable().getGroupName(), true) : stmt.join(SQLJoin.JoinType.INNER_JOIN, null, this.joinElementMapping, (Table)table, null, candidateIdMapping, null, stmt.getPrimaryTable().getGroupName(), true);
        }
        SQLExpressionFactory factory = this.storeMgr.getSQLExpressionFactory();
        JavaTypeMapping discriminatorMapping = table.getSurrogateMapping(SurrogateColumnType.DISCRIMINATOR, false);
        DiscriminatorMetaData discriminatorMetaData = table.getDiscriminatorMetaData();
        if (discriminatorMapping != null && discriminatorMetaData.getStrategy() != DiscriminatorStrategy.NONE) {
            BooleanExpression discExpr = SQLStatementHelper.getExpressionForDiscriminatorForClass(stmt, className, discriminatorMetaData, discriminatorMapping, stmt.getPrimaryTable(), this.clr);
            stmt.whereAnd(discExpr, false);
        }
        for (String subclassName : this.storeMgr.getSubClassesForClass(className, false, this.clr)) {
            DatastoreClass[] subclassTables = null;
            DatastoreClass subclassTable = this.storeMgr.getDatastoreClass(subclassName, this.clr);
            if (subclassTable == null) {
                AbstractClassMetaData targetSubCmd = this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(subclassName, this.clr);
                AbstractClassMetaData[] targetSubCmds = this.storeMgr.getClassesManagingTableForClass(targetSubCmd, this.clr);
                subclassTables = new DatastoreClass[targetSubCmds.length];
                for (int i = 0; i < targetSubCmds.length; ++i) {
                    subclassTables[i] = this.storeMgr.getDatastoreClass(targetSubCmds[i].getFullClassName(), this.clr);
                }
            } else {
                subclassTables = new DatastoreClass[]{subclassTable};
            }
            for (int i = 0; i < subclassTables.length; ++i) {
                if (subclassTables[i] == table) continue;
                JavaTypeMapping subclassIdMapping = subclassTables[i].getIdMapping();
                SQLTable sqlTableSubclass = stmt.join(SQLJoin.JoinType.LEFT_OUTER_JOIN, null, this.joinElementMapping, (Table)subclassTables[i], null, subclassIdMapping, null, stmt.getPrimaryTable().getGroupName(), true);
                SQLExpression subclassIdExpr = factory.newExpression(stmt, sqlTableSubclass, subclassIdMapping);
                NullLiteral nullExpr = new NullLiteral(stmt, null, null, null);
                stmt.whereAnd(subclassIdExpr.eq(nullExpr), false);
            }
        }
        if (this.hasOption("selectDnType")) {
            this.addTypeSelectForClass(stmt, className);
        }
        return stmt;
    }

    private void addTypeSelectForClass(SelectStatement stmt, String className) {
        JavaTypeMapping m = this.storeMgr.getMappingManager().getMapping(String.class);
        String nuctypeName = className;
        if (this.maxClassNameLength > nuctypeName.length()) {
            nuctypeName = StringUtils.leftAlignedPaddedString((String)nuctypeName, (int)this.maxClassNameLength);
        }
        StringLiteral lit = new StringLiteral((SQLStatement)stmt, m, (Object)nuctypeName, null);
        stmt.select(lit, DN_TYPE_COLUMN);
    }
}

