/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.time.LocalTime;
import java.time.OffsetTime;
import org.datanucleus.store.types.converters.TypeConverter;

public class OffsetTimeLongConverter
implements TypeConverter<OffsetTime, Long> {
    private static final long serialVersionUID = 7502678558541569308L;

    @Override
    public OffsetTime toMemberType(Long val) {
        if (val == null) {
            return null;
        }
        LocalTime time = LocalTime.ofNanoOfDay(val);
        return OffsetTime.from(time);
    }

    @Override
    public Long toDatastoreType(OffsetTime time) {
        return time != null ? Long.valueOf(time.toLocalTime().toNanoOfDay()) : null;
    }
}

