/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.types.scostore.CollectionStore;

public class SCOCollectionIterator<E>
implements Iterator<E> {
    private final Iterator<E> iter;
    private E last = null;
    private Collection<E> ownerSCO;

    public SCOCollectionIterator(Collection<E> sco, ObjectProvider op, Collection<E> theDelegate, CollectionStore<E> backingStore, boolean useDelegate) {
        this.ownerSCO = sco;
        ArrayList<E> entries = new ArrayList<E>();
        Iterator<E> i = null;
        i = useDelegate ? theDelegate.iterator() : (backingStore != null ? backingStore.iterator(op) : theDelegate.iterator());
        while (i.hasNext()) {
            entries.add(i.next());
        }
        this.iter = entries.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public E next() {
        this.last = this.iter.next();
        return this.last;
    }

    @Override
    public void remove() {
        if (this.last == null) {
            throw new IllegalStateException();
        }
        this.ownerSCO.remove(this.last);
        this.last = null;
    }
}

