/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusFatalUserException;
import org.datanucleus.metadata.AbstractElementMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.InvalidMemberMetaDataException;

public class ValueMetaData
extends AbstractElementMetaData {
    private static final long serialVersionUID = -3179830024157613599L;

    public ValueMetaData(ValueMetaData vmd) {
        super(vmd);
    }

    public ValueMetaData() {
    }

    @Override
    public void populate(ClassLoaderResolver clr, ClassLoader primary) {
        AbstractMemberMetaData mmd = (AbstractMemberMetaData)this.parent;
        if (mmd.getMap() == null) {
            throw new NucleusFatalUserException("The field " + mmd.getFullFieldName() + " is defined with <value>, however no <map> definition was found.");
        }
        if (this.hasExtension("type-converter-name") && mmd.getMap().value.embedded == null) {
            mmd.getMap().value.embedded = Boolean.TRUE;
        }
        mmd.getMap().value.populate(mmd.getAbstractClassMetaData().getPackageName(), clr, primary);
        String valueType = mmd.getMap().getValueType();
        Class valueTypeClass = null;
        try {
            valueTypeClass = clr.classForName(valueType, primary);
        }
        catch (ClassNotResolvedException cnre) {
            throw new InvalidMemberMetaDataException("044150", mmd.getClassName(), mmd.getName(), valueType);
        }
        if (this.embeddedMetaData != null && (valueTypeClass.isInterface() || valueTypeClass.getName().equals("java.lang.Object"))) {
            throw new InvalidMemberMetaDataException("044152", mmd.getClassName(), mmd.getName(), valueTypeClass.getName());
        }
        if (this.embeddedMetaData == null && mmd.hasMap() && mmd.getMap().isEmbeddedValue() && mmd.getJoinMetaData() != null && mmd.getMap().valueIsPersistent()) {
            this.embeddedMetaData = new EmbeddedMetaData();
            this.embeddedMetaData.parent = this;
        }
        super.populate(clr, primary);
    }
}

