/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.MetaDataUtils;

public class MetaData
implements Serializable {
    private static final long serialVersionUID = -5477406260914096062L;
    public static final int METADATA_CREATED_STATE = 0;
    public static final int METADATA_POPULATED_STATE = 1;
    public static final int METADATA_INITIALISED_STATE = 2;
    public static final int METADATA_USED_STATE = 3;
    public static final String VENDOR_NAME = "datanucleus";
    public static final String EXTENSION_CLASS_READ_ONLY = "read-only";
    public static final String EXTENSION_CLASS_MULTITENANCY_DISABLE = "multitenancy-disable";
    public static final String EXTENSION_CLASS_MULTITENANCY_COLUMN_NAME = "multitenancy-column-name";
    public static final String EXTENSION_CLASS_MULTITENANCY_COLUMN_LENGTH = "multitenancy-column-length";
    public static final String EXTENSION_CLASS_MULTITENANCY_JDBC_TYPE = "multitenancy-jdbc-type";
    public static final String EXTENSION_CLASS_SOFTDELETE = "softdelete";
    public static final String EXTENSION_CLASS_SOFTDELETE_COLUMN_NAME = "softdelete-column-name";
    public static final String EXTENSION_CLASS_VERSION_FIELD_NAME = "field-name";
    public static final String EXTENSION_VERSION_NUMBER_INITIAL_VALUE = "version-initial-value";
    public static final String EXTENSION_MEMBER_TYPE_CONVERTER_NAME = "type-converter-name";
    public static final String EXTENSION_MEMBER_TYPE_CONVERTER_DISABLED = "type-converter-disabled";
    public static final String EXTENSION_MEMBER_COMPARATOR_NAME = "comparator-name";
    public static final String EXTENSION_MEMBER_IMPLEMENTATION_CLASSES = "implementation-classes";
    public static final String EXTENSION_MEMBER_KEY_IMPLEMENTATION_CLASSES = "key-implementation-classes";
    public static final String EXTENSION_MEMBER_VALUE_IMPLEMENTATION_CLASSES = "value-implementation-classes";
    public static final String EXTENSION_MEMBER_ENUM_VALUE_GETTER = "enum-value-getter";
    public static final String EXTENSION_MEMBER_ENUM_GETTER_BY_VALUE = "enum-getter-by-value";
    public static final String EXTENSION_MEMBER_CALENDAR_ONE_COLUMN = "calendar-one-column";
    public static final String EXTENSION_MEMBER_INSERTABLE = "insertable";
    public static final String EXTENSION_MEMBER_UPDATEABLE = "updateable";
    public static final String EXTENSION_MEMBER_CASCADE_PERSIST = "cascade-persist";
    public static final String EXTENSION_MEMBER_CASCADE_UPDATE = "cascade-update";
    public static final String EXTENSION_MEMBER_CASCADE_DETACH = "cascade-detach";
    public static final String EXTENSION_MEMBER_CASCADE_REFRESH = "cascade-refresh";
    public static final String EXTENSION_MEMBER_CACHEABLE = "cacheable";
    public static final String EXTENSION_MEMBER_FETCH_FK_ONLY = "fetch-fk-only";
    public static final String EXTENSION_MEMBER_CONTAINER_ALLOW_NULLS = "allow-nulls";
    public static final String EXTENSION_MEMBER_LIST_ORDERING = "list-ordering";
    public static final String EXTENSION_MEMBER_STRATEGY_WHEN_NOTNULL = "strategy-when-notnull";
    public static final String EXTENSION_MEMBER_RELATION_DISCRIM_COLUMN = "relation-discriminator-column";
    public static final String EXTENSION_MEMBER_RELATION_DISCRIM_VALUE = "relation-discriminator-value";
    public static final String EXTENSION_MEMBER_RELATION_DISCRIM_PK = "relation-discriminator-pk";
    public static final String EXTENSION_CLASS_VIEW_DEFINITION = "view-definition";
    public static final String EXTENSION_CLASS_VIEW_IMPORTS = "view-imports";
    protected int metaDataState = 0;
    protected MetaData parent;
    protected Map<String, String> extensions = null;

    public MetaData() {
    }

    public MetaData(MetaData parent) {
        this.parent = parent;
    }

    public MetaData(MetaData parent, MetaData copy) {
        this.parent = parent;
        if (copy != null && copy.extensions != null) {
            if (this.extensions == null) {
                this.extensions = new HashMap<String, String>(copy.extensions);
            } else {
                this.extensions.clear();
                this.extensions.putAll(copy.extensions);
            }
        }
    }

    public void initialise(ClassLoaderResolver clr) {
        this.setInitialised();
    }

    void setInitialised() {
        this.metaDataState = 2;
    }

    void setPopulated() {
        this.metaDataState = 1;
    }

    void setUsed() {
        this.metaDataState = 3;
    }

    public boolean isPopulated() {
        return this.metaDataState >= 1;
    }

    public boolean isInitialised() {
        return this.metaDataState >= 2;
    }

    public boolean isUsed() {
        return this.metaDataState == 3;
    }

    public MetaDataManager getMetaDataManager() {
        return this.parent != null ? this.parent.getMetaDataManager() : null;
    }

    public void setParent(MetaData md) {
        if (this.isPopulated() || this.isInitialised()) {
            throw new NucleusException("Cannot set parent of " + this + " since it is already populated/initialised");
        }
        this.parent = md;
    }

    public MetaData getParent() {
        return this.parent;
    }

    public MetaData addExtensions(Map<String, String> exts) {
        if (exts == null || exts.size() == 0) {
            return this;
        }
        if (this.extensions == null) {
            this.extensions = new HashMap<String, String>(exts);
        } else {
            this.extensions.putAll(exts);
        }
        return this;
    }

    public MetaData setExtensions(Map<String, String> exts) {
        this.extensions = exts == null ? null : new HashMap<String, String>(exts);
        return this;
    }

    public MetaData addExtension(String key, String value) {
        if (key == null || value == null) {
            throw new InvalidMetaDataException("044160", VENDOR_NAME, key, value);
        }
        if (this.hasExtension(key)) {
            this.removeExtension(key);
        }
        if (this.extensions == null) {
            this.extensions = new HashMap<String, String>();
        }
        this.extensions.put(key, value);
        return this;
    }

    public MetaData removeExtension(String key) {
        if (this.extensions == null) {
            return this;
        }
        this.extensions.remove(key);
        return this;
    }

    public int getNoOfExtensions() {
        return this.extensions != null ? this.extensions.size() : 0;
    }

    public Map<String, String> getExtensions() {
        if (this.extensions == null || this.extensions.isEmpty()) {
            return null;
        }
        return this.extensions;
    }

    public boolean hasExtension(String key) {
        if (this.extensions == null || key == null) {
            return false;
        }
        return this.extensions.containsKey(key);
    }

    public String getValueForExtension(String key) {
        if (this.extensions == null || key == null) {
            return null;
        }
        return this.extensions.get(key);
    }

    public String[] getValuesForExtension(String key) {
        if (this.extensions == null || key == null) {
            return null;
        }
        String value = this.extensions.get(key);
        if (value != null) {
            return MetaDataUtils.getInstance().getValuesForCommaSeparatedAttribute(value);
        }
        return null;
    }
}

