/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.identity;

import java.io.Serializable;
import org.datanucleus.identity.DatastoreId;
import org.datanucleus.util.Localiser;

public class DatastoreIdImplKodo
implements Serializable,
DatastoreId,
Comparable {
    private static final long serialVersionUID = -427334762583525878L;
    protected static final transient String STRING_DELIMITER = "-";
    public final Object keyAsObject;
    public final String targetClassName;
    public final String toString;
    public final int hashCode;

    public DatastoreIdImplKodo(String pcClass, Object key) {
        this.targetClassName = pcClass;
        this.keyAsObject = key;
        StringBuilder s = new StringBuilder();
        s.append(this.targetClassName);
        s.append(STRING_DELIMITER);
        s.append(this.keyAsObject.toString());
        this.toString = s.toString();
        this.hashCode = this.toString.hashCode();
    }

    public DatastoreIdImplKodo(String str) throws IllegalArgumentException {
        if (str.length() < 2) {
            throw new IllegalArgumentException(Localiser.msg("038000", str));
        }
        int separatorPosition = str.indexOf(STRING_DELIMITER);
        this.targetClassName = str.substring(0, separatorPosition);
        String oidStr = str.substring(separatorPosition + 1);
        Object oidValue = null;
        try {
            oidValue = Long.valueOf(oidStr);
        }
        catch (NumberFormatException nfe) {
            oidValue = oidStr;
        }
        this.keyAsObject = oidValue;
        this.toString = str;
        this.hashCode = this.toString.hashCode();
    }

    @Override
    public Object getKeyAsObject() {
        return this.keyAsObject;
    }

    @Override
    public String getTargetClassName() {
        return this.targetClassName;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().getName().equals(DatastoreIdImplKodo.class.getName())) {
            return false;
        }
        if (this.hashCode() != obj.hashCode()) {
            return false;
        }
        return ((DatastoreId)obj).toString().equals(this.toString);
    }

    public int compareTo(Object o) {
        if (o instanceof DatastoreIdImplKodo) {
            DatastoreIdImplKodo c = (DatastoreIdImplKodo)o;
            return this.toString.compareTo(c.toString);
        }
        if (o == null) {
            throw new ClassCastException("object is null");
        }
        throw new ClassCastException(this.getClass().getName() + " != " + o.getClass().getName());
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String toString() {
        return this.toString;
    }
}

