/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.QueryResultMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.fieldmanager.ResultSetGetter;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.query.AbstractROF;
import org.datanucleus.store.rdbms.query.StatementClassMapping;
import org.datanucleus.store.rdbms.query.StatementMappingIndex;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.schema.table.SurrogateColumnType;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.datanucleus.util.TypeConversionHelper;

public class ResultMetaDataROF
extends AbstractROF {
    QueryResultMetaData queryResultMetaData = null;
    String[] columnNames = null;
    protected ResultSetGetter[] persistentTypeResultSetGetters = null;

    public ResultMetaDataROF(ExecutionContext ec, ResultSet rs, boolean ignoreCache, QueryResultMetaData qrmd) {
        super(ec, rs, ignoreCache);
        this.queryResultMetaData = qrmd;
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            this.columnNames = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                String colName = rsmd.getColumnName(i + 1);
                String colLabel = rsmd.getColumnLabel(i + 1);
                this.columnNames[i] = StringUtils.isWhitespace((String)colLabel) ? colName : colLabel;
            }
        }
        catch (SQLException ex) {
            throw new NucleusDataStoreException("Error obtaining objects", (Throwable)ex);
        }
    }

    @Override
    public ResultSet getResultSet() {
        return this.rs;
    }

    @Override
    public Object getObject() {
        QueryResultMetaData.ConstructorTypeMapping[] ctrTypeMappings;
        String[] columns;
        int i;
        ArrayList<Object> returnObjects = new ArrayList<Object>();
        QueryResultMetaData.PersistentTypeMapping[] persistentTypes = this.queryResultMetaData.getPersistentTypeMappings();
        if (persistentTypes != null) {
            if (this.persistentTypeResultSetGetters == null) {
                this.persistentTypeResultSetGetters = new ResultSetGetter[persistentTypes.length];
            }
            int startColumnIndex = 0;
            for (i = 0; i < persistentTypes.length; ++i) {
                ResultSetGetter rsGetter;
                StatementClassMapping resultMappings;
                HashSet<String> columnsInThisType = new HashSet<String>();
                AbstractMemberMetaData[] mmds = new AbstractMemberMetaData[this.columnNames.length];
                HashMap<String, AbstractMemberMetaData> fieldColumns = new HashMap<String, AbstractMemberMetaData>();
                DatastoreClass dc = ((RDBMSStoreManager)this.ec.getStoreManager()).getDatastoreClass(persistentTypes[i].getClassName(), this.ec.getClassLoaderResolver());
                AbstractClassMetaData acmd = this.ec.getMetaDataManager().getMetaDataForClass(persistentTypes[i].getClassName(), this.ec.getClassLoaderResolver());
                Object id = null;
                for (int j = startColumnIndex; j < this.columnNames.length; ++j) {
                    JavaTypeMapping datastoreIdMapping;
                    Column df;
                    if (columnsInThisType.contains(this.columnNames[j])) {
                        startColumnIndex = j;
                        break;
                    }
                    boolean found = false;
                    if (acmd.getIdentityType() == IdentityType.DATASTORE && (df = (datastoreIdMapping = dc.getSurrogateMapping(SurrogateColumnType.DATASTORE_ID, false)).getDatastoreMapping(0).getColumn()).getIdentifier().getName().equalsIgnoreCase(this.columnNames[j])) {
                        int datastoreIdentityExpressionIndex = j + 1;
                        id = datastoreIdMapping.getObject(this.ec, this.rs, new int[]{datastoreIdentityExpressionIndex});
                        found = true;
                    }
                    for (int k = 0; k < acmd.getNoOfManagedMembers() + acmd.getNoOfInheritedManagedMembers() && !found; ++k) {
                        AbstractMemberMetaData apmd = acmd.getMetaDataForManagedMemberAtAbsolutePosition(k);
                        if (persistentTypes[i].getColumnForField(apmd.getName()) != null) {
                            if (!persistentTypes[i].getColumnForField(apmd.getName()).equalsIgnoreCase(this.columnNames[j])) continue;
                            fieldColumns.put(this.columnNames[j], apmd);
                            columnsInThisType.add(this.columnNames[j]);
                            mmds[j] = apmd;
                            found = true;
                            continue;
                        }
                        JavaTypeMapping mapping = dc.getMemberMapping(apmd);
                        for (int l = 0; l < mapping.getDatastoreMappings().length && !found; ++l) {
                            Column df2 = mapping.getDatastoreMapping(l).getColumn();
                            if (!df2.getIdentifier().getName().equalsIgnoreCase(this.columnNames[j])) continue;
                            fieldColumns.put(this.columnNames[j], apmd);
                            columnsInThisType.add(this.columnNames[j]);
                            mmds[j] = apmd;
                            found = true;
                        }
                    }
                    if (columnsInThisType.contains(this.columnNames[j])) continue;
                    startColumnIndex = j;
                    break;
                }
                StatementMappingIndex[] stmtMappings = new StatementMappingIndex[acmd.getNoOfManagedMembers() + acmd.getNoOfInheritedManagedMembers()];
                HashSet resultMmds = new HashSet();
                resultMmds.addAll(fieldColumns.values());
                final int[] resultFieldNumbers = new int[resultMmds.size()];
                int j = 0;
                for (AbstractMemberMetaData apmd : resultMmds) {
                    StatementMappingIndex stmtMapping = new StatementMappingIndex(dc.getMemberMapping(apmd));
                    resultFieldNumbers[j] = apmd.getAbsoluteFieldNumber();
                    ArrayList<Integer> indexes = new ArrayList<Integer>();
                    for (int k = 0; k < mmds.length; ++k) {
                        if (mmds[k] != apmd) continue;
                        indexes.add(k);
                    }
                    int[] indxs = new int[indexes.size()];
                    for (int k = 0; k < indxs.length; ++k) {
                        indxs[k] = (Integer)indexes.get(k) + 1;
                    }
                    stmtMapping.setColumnPositions(indxs);
                    stmtMappings[resultFieldNumbers[j]] = stmtMapping;
                    ++j;
                }
                Object obj = null;
                Class type = this.ec.getClassLoaderResolver().classForName(persistentTypes[i].getClassName());
                if (acmd.getIdentityType() == IdentityType.APPLICATION) {
                    if (this.persistentTypeResultSetGetters[i] == null) {
                        resultMappings = new StatementClassMapping();
                        for (int k = 0; k < resultFieldNumbers.length; ++k) {
                            resultMappings.addMappingForMember(resultFieldNumbers[k], stmtMappings[resultFieldNumbers[k]]);
                        }
                        this.persistentTypeResultSetGetters[i] = new ResultSetGetter(this.ec, this.rs, resultMappings, acmd);
                    }
                    rsGetter = this.persistentTypeResultSetGetters[i];
                    id = IdentityUtils.getApplicationIdentityForResultSetRow((ExecutionContext)this.ec, (AbstractClassMetaData)acmd, (Class)type, (boolean)false, (FieldManager)rsGetter);
                    obj = this.ec.findObject(id, new FieldValues(){

                        public void fetchFields(ObjectProvider op) {
                            rsGetter.setObjectProvider(op);
                            op.replaceFields(resultFieldNumbers, (FieldManager)rsGetter, false);
                        }

                        public void fetchNonLoadedFields(ObjectProvider op) {
                            rsGetter.setObjectProvider(op);
                            op.replaceNonLoadedFields(resultFieldNumbers, (FieldManager)rsGetter);
                        }

                        public FetchPlan getFetchPlanForLoading() {
                            return null;
                        }
                    }, type, this.ignoreCache, false);
                } else if (acmd.getIdentityType() == IdentityType.DATASTORE) {
                    if (this.persistentTypeResultSetGetters[i] == null) {
                        resultMappings = new StatementClassMapping();
                        for (int k = 0; k < resultFieldNumbers.length; ++k) {
                            resultMappings.addMappingForMember(resultFieldNumbers[k], stmtMappings[resultFieldNumbers[k]]);
                        }
                        this.persistentTypeResultSetGetters[i] = new ResultSetGetter(this.ec, this.rs, resultMappings, acmd);
                    }
                    rsGetter = this.persistentTypeResultSetGetters[i];
                    obj = this.ec.findObject(id, new FieldValues(){

                        public void fetchFields(ObjectProvider op) {
                            rsGetter.setObjectProvider(op);
                            op.replaceFields(resultFieldNumbers, (FieldManager)rsGetter, false);
                        }

                        public void fetchNonLoadedFields(ObjectProvider op) {
                            rsGetter.setObjectProvider(op);
                            op.replaceNonLoadedFields(resultFieldNumbers, (FieldManager)rsGetter);
                        }

                        public FetchPlan getFetchPlanForLoading() {
                            return null;
                        }
                    }, type, this.ignoreCache, false);
                } else {
                    NucleusLogger.QUERY.warn((Object)"We do not currently support non-durable objects in the results of this type of query.");
                }
                returnObjects.add(obj);
            }
        }
        if ((columns = this.queryResultMetaData.getScalarColumns()) != null) {
            for (i = 0; i < columns.length; ++i) {
                try {
                    Object obj = this.rs.getObject(columns[i]);
                    returnObjects.add(obj);
                    continue;
                }
                catch (SQLException sqe) {
                    String msg = Localiser.msg((String)"059027", (Object[])new Object[]{sqe.getMessage()});
                    NucleusLogger.QUERY.error((Object)msg);
                    throw new NucleusUserException(msg, (Throwable)sqe);
                }
            }
        }
        if ((ctrTypeMappings = this.queryResultMetaData.getConstructorTypeMappings()) != null) {
            for (int i2 = 0; i2 < ctrTypeMappings.length; ++i2) {
                String ctrClassName = ctrTypeMappings[i2].getClassName();
                Class ctrCls = this.ec.getClassLoaderResolver().classForName(ctrClassName);
                List ctrColumns = ctrTypeMappings[i2].getColumnsForConstructor();
                Class[] ctrArgTypes = null;
                Object[] ctrArgVals = null;
                if (ctrColumns != null && ctrColumns.size() > 0) {
                    int j = 0;
                    ctrArgTypes = new Class[ctrColumns.size()];
                    ctrArgVals = new Object[ctrColumns.size()];
                    for (QueryResultMetaData.ConstructorTypeColumn ctrCol : ctrColumns) {
                        try {
                            Object colVal = this.rs.getObject(ctrCol.getColumnName());
                            ctrArgTypes[j] = colVal.getClass();
                            if (ctrCol.getJavaType() != null) {
                                ctrArgTypes[j] = ctrCol.getJavaType();
                                ctrArgVals[j] = TypeConversionHelper.convertTo((Object)colVal, (Class)ctrArgTypes[j]);
                            } else {
                                ctrArgTypes[j] = colVal.getClass();
                                ctrArgVals[j] = colVal;
                            }
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        ++j;
                    }
                }
                returnObjects.add(ClassUtils.newInstance((Class)ctrCls, ctrArgTypes, ctrArgVals));
            }
        }
        if (returnObjects.size() == 0) {
            return null;
        }
        if (returnObjects.size() == 1) {
            return returnObjects.get(0);
        }
        return returnObjects.toArray(new Object[returnObjects.size()]);
    }
}

