/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.jcc.t4;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ServerListEntry
implements Serializable {
    private static final long serialVersionUID = 6677872638504273601L;
    private String[] serverName_ = null;
    private int[] portNumber_ = null;
    private InetAddress[] inetAddress_ = null;
    private long lastUpdated_;

    public ServerListEntry(String[] stringArray, int[] nArray, long l2) {
        int n2 = stringArray.length;
        this.serverName_ = new String[n2];
        this.portNumber_ = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.serverName_[i2] = stringArray[i2];
            this.portNumber_[i2] = nArray[i2];
        }
        this.inetAddress_ = new InetAddress[this.serverName_.length];
        this.lastUpdated_ = l2;
        this.updateInetAddress();
    }

    public synchronized void update(String[] stringArray, int[] nArray, InetAddress[] inetAddressArray, long l2) {
        this.serverName_ = stringArray;
        this.portNumber_ = nArray;
        this.inetAddress_ = inetAddressArray;
        this.lastUpdated_ = l2;
    }

    public synchronized void updateServer(String[] stringArray) {
        this.serverName_ = stringArray;
        this.updateInetAddress();
    }

    public synchronized void updatePortNumber(int[] nArray) {
        this.portNumber_ = nArray;
    }

    public synchronized void updateLastUpdatedTime(long l2) {
        this.lastUpdated_ = l2;
    }

    private void updateInetAddress() {
        if (this.inetAddress_.length != this.serverName_.length) {
            this.inetAddress_ = new InetAddress[this.serverName_.length];
        }
        for (int i2 = 0; i2 < this.serverName_.length; ++i2) {
            try {
                this.inetAddress_[i2] = InetAddress.getByName(this.serverName_[i2]);
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                this.inetAddress_[i2] = null;
            }
        }
    }

    public String[] getServerName() {
        return this.serverName_;
    }

    public int[] getPortNumber() {
        return this.portNumber_;
    }

    public InetAddress[] getInetAddress() {
        return this.inetAddress_;
    }

    public long getLastUpdatedTime() {
        return this.lastUpdated_;
    }
}

