%
% listeDiListe.pl 
%  

%
% numat(L,N)		"N e` il numero di atomi nella lista L"
%
% plain(L1,L2)		"L2  la lista appiattita della lista di
%			 liste L1"
%
% is_list(L)		"L  una lista"
%
% insertOL(L1,L,X)	"X  la lista ordinata L in cui viene inserita
%			 in modo ordinato la lista L1"
%
% lung(L,N)		"N  la lunghezza della lista L"
%


%
% a)
%

numat([],0) :- !.
numat([HEAD|TAIL],N) :- numat(HEAD,N1),
                        numat(TAIL,N2),
                        N is N1+N2,
                        !.
numat(_,1).


%
% Alternativa:
%
% numat([],0).
% numat([X|Y],Num):- is_a_list(X), !,numat(X,Num1), numat(Y,Num2), Num is Num1 + Num2.
% numat([X|Y],Num):- numat(Y,Num2), Num is 1 + Num2.
%
% is_a_list([]).
% is_a_list([_|_]).
%



%
% b)
%

plain([],[]):-!.
plain([H|T],L):-is_list(H),!,
        plain(H,L1),
        plain(T,L2),
        append(L1,L2,L).
plain([H|T],[H|L2]):-
        plain(T,L2).

 
is_list([]):- !.
is_list([_|T]):- is_list(T).



%
% c)
%

insertOL(X, [], [X]).
insertOL(X, [Y|Ys], [Y|Zs]):- lung(X,N),
		 	      lung(Y,N1), N>N1, !,
         		      insertOL(X,Ys, Zs).
insertOL(X, Zs, [X|Zs]).

lung([],0).
lung([_|B],N):- lung(B,N1), N is N1 +1.

