%
% prodcartesiano.pl 
%  


%
% prodotto_cartesiano(L1,L2,L3)	"L3  la lista delle coppie ordinate che
% 				 si possono formare con gli elementi delle
%				 liste L1 e L2"
%
% prod(A,L1,L2)			"L2  la lista delle coppie ordinate che si
% 				 possono formare con A e gli elementi di L1"
%
% append(L1,L2,L)		"L  la concatenazione delle liste L1 e L2"
%

prodotto_cartesiano([],_,[]).
prodotto_cartesiano([A|T],L2,L3):- prod(A,L2,L),
				   prodotto_cartesiano(T,L2,L4),
				   append(L,L4,L3).

prod(_,[],[]).
prod(A,[H|T],[[A,H]|M]):- prod(A,T,M).

append([],X,X).
append([X|L1],L2,[X|L3]):- append(L1,L2,L3).

