%
% crypto.pl 
%  

% 
% sum(N1,N2,N)    "Sommando la lista di caratteri N1 alla lista di caratteri N2 
%                  si ottiene la lista di caratteri N e ad ogni carattere 
%                  incognito viene assegnata una cifra diversa" 
% 
% Relazioni "ausiliarie": 
% 
% sum(N1,N2,N,C1,C2,Digs1,Digs2)     "Opera come sum(N1,N2,N), considerando un 
%                                     riporto iniziale C1, un riporto finale C2, 
%                                     un insieme di cifre disponibili Digs1, un 
%                                     insieme di cifre non utilizzate Digs2" 
% 
% digitsum(D1,D2,C1,D,C,Digs1,Digs)  "Sommando D1, D2 e C1 si ottiene D con 
%                                     riporto C e ad ogni carattere incognito 
%                                     viene assegnata una cifra diversa; 
%                                     l'insieme delle cifre disponibili e` 
%                                     Digs1, quello delle cifre non utilizzate 
%                                     e` Digs2" 
% 
% del(D,Digs1,Digs2)                 "Se D non e` istanziata l'insieme Digs2 si 
%                                     ottiene dall'insieme Digs1 eliminando il 
%                                     primo termine che unifica con D; 
%                                     se D e` gia` istanziata l'insieme Digs2 
%                                     coincide con Digs1" 
%   


sum(N1,N2,N) :- sum(N1,N2,N,0,0,[0,1,2,3,4,5,6,7,8,9],_).

sum([],[],[],0,0,Digs,Digs).
 
sum([D1|N1],[D2|N2],[D|N],C1,C,Digs1,Digs) :- sum(N1,N2,N,C1,C2,Digs1,Digs2),
                                              digitsum(D1,D2,C2,D,C,Digs2,Digs).
 
 
digitsum(D1,D2,C1,D,C,Digs1,Digs) :- del(D1,Digs1,Digs2),
                                     del(D2,Digs2,Digs3),
                                     del(D,Digs3,Digs),
                                     S is D1+D2+C1,
                                     D is S mod 10,
                                     C is S // 10.
  
 
del(D,Digs,Digs) :- nonvar(D),!.
 
del(D,[D|Digs2],Digs2).

del(D,[H|Digs1],[H|Digs2]) :- del(D,Digs1,Digs2).
  
 
% 
% Determinazione del numero di soluzioni: 
%  
% ?- findall([A,B,C,D,E,F],sum([A,B],[C,D],[E,F]),INS), length(INS,NUM). 
% INS = [[4, 1, 5, 2, 9, 3], [5, 1, 4, 2, 9, 3], [2, 1, 5, 3, 7, 4], ... ] 
% NUM = 692 ; 
% No 
%
