%
% liste.pl
%

%
% len(L,N)               "N  la lunghezza (numero di elementi) di L"
%                         (realizzazione ricorsiva)
%
% len1(L,N)              "N  la lunghezza (numero di elementi) di L"
%                         (realizzazione iterativa)
%
% depth_member(T,L)      "T appartiene alla lista L o, ricorsivamente, ad una
%                         lista che appartiene a L"
%
% append(L1,L2,L)        "L  la concatenazione delle liste L1 e L2"
%
% reverse(L1,L2)         "L2  la lista inversa di L1"
%                         (realizzazione ricorsiva)
%
% reverse1(L1,L2)        "L2  la lista inversa di L1"
%                         (realizzazione iterativa)
%


%
% (a)
%

len([],0).
len([_|L],N) :- len(L,N1),
                N is N1+1.


len1(L,N) :- len1(L,0,N).

len1([],ACC,ACC).
len1([_|L],ACC,N) :- ACC1 is ACC+1,
                     len1(L,ACC1,N).



%
% (b)
%

depth_member(T,[T|_]).
depth_member(T,[L|_]) :- depth_member(T,L).
depth_member(T,[_|L]) :- depth_member(T,L).



%
% (c)
%

append([],L,L).
append([HEAD|TAIL],L,[HEAD|TAIL1]) :- append(TAIL,L,TAIL1).



%
% (d)
%

reverse([],[]).
reverse([HEAD|TAIL],L2) :- reverse(TAIL,TAIL1),
                           append(TAIL1,[HEAD],L2).


reverse1(L1,L2) :- reverse1(L1,[],L2).

reverse1([],ACC,ACC).
reverse1([HEAD|TAIL],ACC,L2) :- append([HEAD],ACC,ACC1),
                                reverse1(TAIL,ACC1,L2).

