%
% mcd.pl
%


%
% Per evitare che il programma vada in loop, bisogna evitare che venga
% selezionata la terza clausola quando A=B. Una soluzione  quindi imporre
% che la terza clausola venga selezionata solo se A>B.
%

mcd(A,A,A):- !.
mcd(A,B,M):- A<B,!, C is B-A, mcd(A,C,M).
mcd(A,B,M):- A>B, I is A-B, mcd(I,B,M).


%
% Unalternativa  quella di far s che venga selezionata la prima clausola 
% in tutti i casi in cui i due operandi sono uguali ed effettuare a 
% posteriori (dopo il cut) lunificazione del risultato con A:
%
%
% mcd(A,A,M):- !, A=M.
% mcd(A,B,M):- A<B,!, C is B-A, mcd(A,C,M).
% mcd(A,B,M):- I is A-B, mcd(I,B,M).
%
