%
% liste&cut.pl
%

              
%
% intersection(L1,L2,L)	 "L  l'insieme intersezione di L1 ed L2"
%
% member(T,L)		 "T  un elemento della lista L"
%
% last(L,X)		 "X  l'ultimo elemento della lista L"
%
% subset(L1,L2)		 "L2 contiene tutti gli elementi di L1 nello
%			  stesso ordine"
%
% sublist(L1,L2)	 "L2 contiene L1 come parte di s stessa"
%
% member_list(X,L,T)	 "X appartiene alla lista L, e T  la coda
%			  di L a partire da X escluso"
%
% subl_aux(L1,L2)	 "L2 contiene L1 come sottolista iniziale"
%
% palin(L)		 "L  una lista palindroma"
%
% reverse(L1,L2)         "L2  la lista inversa di L1"
%
% append(L1,L2,L)        "L  la concatenazione delle liste L1 e L2"
%
% del_rip(L1,L2)	 "L2  la lista L1 privata di tutte le
%			  ripetizioni"
%
% delete(X,L,R)		 "R  la lista L senza occorrenze di X"
%
% conta(T,L,N)		 "N  il numero di occorrenze del termine
%			  T nella lista L"
%
% insert(N,L,X)		 "X  la lista ordinata L in cui viene
%			  inserito in modo ordinato l'intero N"
%


%
% a)
%

intersection([], _, []).
intersection([X|REST],S2,[X|REST1]) :- member(X, S2), !,
				       intersection(REST, S2, REST1).
intersection([_ | REST], S2, REST1) :- intersection(REST, S2, REST1).


member(T, [T | _]).
member(T, [_ | L]) :- member(T, L).



%
% b)
%

last([X],X):- !.
last([_|T],X):- last(T,X).



%
% c)
%
% sottolista come subset
% L2 contiene tutti gli elementi
% di L1 nello stesso ordine
% Es.
% subset([1,2],[1,3,2,4]) yes
% subset([1,2],[2,3,1,4]) no
%

subset([],_):- !.
subset([X|T],[X|L2]):- !, 
      		       subset(T,L2).
subset(L1,[_|L2]):- subset(L1,L2).


%
% sottolista propria
% L2 contiene L1 come parte di 
% se' stessa; 
% Es.
% sublist([1,2],[3,4,1,2,5]) yes
% sublist([1,2],[3,4,1,5,2]) no
%


sublist([],_):- !.
sublist([X|T],L2):- member_list(X,L2,L2rest),
      		    subl_aux(T,L2rest).

member_list(X,[X|T],T):- !.
member_list(X,[_|T],Trest):- member_list(X,T,Trest).

subl_aux([],_):- !.
subl_aux([X|T],[X|L2]):- subl_aux(T,L2).



%
% d)
%

palin([]):-!.
palin(L1):-reverse(L1,L1).


reverse([],[]).
reverse([HEAD|TAIL],L2) :- reverse(TAIL,TAIL1),
                           append(TAIL1,[HEAD],L2).

append([],L,L).
append([HEAD|TAIL],L,[HEAD|TAIL1]) :- append(TAIL,L,TAIL1).


%
% e)
%
% se X non  membro di T allora 
% va riportato nell'output
%

del_rip([],[]):- !.
del_rip([X|T],[X|T1]):- member(X,T),!,
            		delete(X,T,R),
            		del_rip(R,T1).
del_rip([X|T],[X|T1]):- del_rip(T,T1).


delete(_, [], []).
delete(X, [X | T], R):- !, delete(X, T, R).
delete(X, [H | T], [H | R]):- delete(X, T, R).



%
% f)
%
% se T non  il primo elemento
% di L allora conta nella coda 
% di L
%

conta(T,L,N):- c(T,L,0,N).

c(_,[],N,N).
c(T,[T|R],Nin,Nout):- !,
           	      N1 is Nin+1,
           	      c(T,R,N1,Nout).
c(T,[_|R],Nin,Nout):- c(T,R,Nin,Nout).



%
% g)
%

insert(X, [], [X]).
insert(X, [Y|Ys], [X,Y|Ys]):- X=<Y, !.
insert(X, [Y|Ys], [Y|Zs]):- insert(X,Ys,Zs).

