%
% fib.pl
%

%
% fib(N,F)     "F  l'N-esimo numero di Fibonacci" (versione ricorsiva)
%
%
% fibIter(N,F) "F  l'N-esimo numero di Fibonacci" (versione iterativa)
%

fib(0,0).
fib(1,1).
fib(N,F):-
    N>1,
    N1 is N-1,
    fib(N1,F1),
    N2 is N-2,
    fib(N2,F2),
    F is F1+F2.

fibIter(N,F):-  
    fibIter(2,N,1,0,F).

fibIter(_,0,_,_,0).

fibIter(_,1,_,_,1).
    
fibIter(N,N,Fib_1,Fib_2,F):-
    F is Fib_1 + Fib_2.
    
fibIter(I,N,Fib_1,Fib_2,F):-
    NewFib_1 is Fib_1+Fib_2,
    NewFib_2 is Fib_1,
    I1 is I + 1,
    fibIter(I1,N,NewFib_1,NewFib_2,F).


%
% altra soluzione non iterativa
%

fib1(N,F):-
    fib1(N,0,F).
    
fib1(0,Acc,Acc).
fib1(1,Acc,Acc1):-
    Acc1 is Acc+1.

fib1(N,AccIn,AccOut):-
    N>1,
    N1 is N-1, 
    N2 is N-2, 
    fib1(N1,AccIn,Acc1),
    fib1(N2,Acc1,AccOut).
