%
% parenti.pl
%


%
% Fatti:
%

padre(ugo,luisa).
madre(marina,luisa).
padre(mario,luigi).
madre(luisa,luigi).
padre(mario,giovanna).
madre(luisa,giovanna).
padre(marco,giorgio).
madre(maria,giorgio).
padre(giorgio,andrea).
madre(giovanna,andrea).
padre(giorgio,ilaria).
madre(giovanna,ilaria).



%
% nonno(X,Y)      "X e` nonno di Y"
%
% nonna(X,Y)      "X e` nonna di Y"
%
% bisnonno(X,Y)   "X e` bisnonno di Y"
%
% bisnonna(X,Y)   "X e` bisnonna di Y"
%
% nipote(X,Y)     "X e` nipote di Y"
%
% pronipote(X,Y)  "X e` pronipote di Y"
%


nonno(X,Y) :- padre(X,Z),
              padre(Z,Y).
nonno(X,Y) :- padre(X,Z),
              madre(Z,Y).

nonna(X,Y) :- madre(X,Z),
              padre(Z,Y).
nonna(X,Y) :- madre(X,Z),
              madre(Z,Y).

bisnonno(X,Y) :- padre(X,Z),
                 nonno(Z,Y).
bisnonno(X,Y) :- padre(X,Z),
                 nonna(Z,Y).

bisnonna(X,Y) :- madre(X,Z),
                 nonno(Z,Y).
bisnonna(X,Y) :- madre(X,Z),
                 nonna(Z,Y).

nipote(X,Y) :- nonno(Y,X).
nipote(X,Y) :- nonna(Y,X).

pronipote(X,Y) :- bisnonno(Y,X).
pronipote(X,Y) :- bisnonna(Y,X).

antenato(X,Y):-padre(X,Y).
antenato(X,Y):-madre(X,Y).

antenato(X,Y):-padre(X,Z), antenato(Z,Y).
antenato(X,Y):-madre(X,Z), antenato(Z,Y).

