/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.searches;

import aima.search.framework.Problem;
import aima.search.framework.SearchAgent;
import aima.search.nqueens.NQueensBoard;
import aima.search.nqueens.NQueensGoalTest;
import aima.search.nqueens.NQueensSuccessorFunction;
import aima.search.uninformed.DepthLimitedSearch;
import java.util.List;
import junit.framework.TestCase;

public class DepthLimitedSearchTest
extends TestCase {
    public void testSuccesfulDepthLimitedSearch() throws Exception {
        Problem problem = new Problem(new NQueensBoard(8), new NQueensSuccessorFunction(), new NQueensGoalTest());
        DepthLimitedSearch depthLimitedSearch = new DepthLimitedSearch(8);
        SearchAgent searchAgent = new SearchAgent(problem, depthLimitedSearch);
        List list = searchAgent.getActions();
        this.assertCorrectPlacement(list);
        DepthLimitedSearchTest.assertEquals((String)"113", (String)searchAgent.getInstrumentation().getProperty("nodesExpanded"));
    }

    public void testCutOff() throws Exception {
        Problem problem = new Problem(new NQueensBoard(8), new NQueensSuccessorFunction(), new NQueensGoalTest());
        DepthLimitedSearch depthLimitedSearch = new DepthLimitedSearch(1);
        SearchAgent searchAgent = new SearchAgent(problem, depthLimitedSearch);
        List list = searchAgent.getActions();
        DepthLimitedSearchTest.assertEquals((Object)"cutoff", list.get(0));
    }

    public void testFailure() throws Exception {
        Problem problem = new Problem(new NQueensBoard(3), new NQueensSuccessorFunction(), new NQueensGoalTest());
        DepthLimitedSearch depthLimitedSearch = new DepthLimitedSearch(5);
        SearchAgent searchAgent = new SearchAgent(problem, depthLimitedSearch);
        List list = searchAgent.getActions();
        DepthLimitedSearchTest.assertEquals((int)0, (int)list.size());
    }

    private void assertCorrectPlacement(List list) {
        DepthLimitedSearchTest.assertEquals((int)8, (int)list.size());
        DepthLimitedSearchTest.assertEquals((Object)"placeQueenAt 0  0", list.get(0));
        DepthLimitedSearchTest.assertEquals((Object)"placeQueenAt 1  4", list.get(1));
        DepthLimitedSearchTest.assertEquals((Object)"placeQueenAt 2  7", list.get(2));
        DepthLimitedSearchTest.assertEquals((Object)"placeQueenAt 3  5", list.get(3));
        DepthLimitedSearchTest.assertEquals((Object)"placeQueenAt 4  2", list.get(4));
        DepthLimitedSearchTest.assertEquals((Object)"placeQueenAt 5  6", list.get(5));
        DepthLimitedSearchTest.assertEquals((Object)"placeQueenAt 6  1", list.get(6));
        DepthLimitedSearchTest.assertEquals((Object)"placeQueenAt 7  3", list.get(7));
    }
}

