/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.online;

import aima.basic.BasicEnvironmentView;
import aima.search.map.BidirectionalMapProblem;
import aima.search.map.ExtendableMap;
import aima.search.map.MapEnvironment;
import aima.search.online.OnlineDFSAgent;
import junit.framework.TestCase;

public class OnlineDFSAgentTest
extends TestCase {
    ExtendableMap aMap;
    StringBuffer envChanges;

    public void setUp() {
        this.aMap = new ExtendableMap();
        this.aMap.addBidirectionalLink("A", "B", 5.0);
        this.aMap.addBidirectionalLink("A", "C", 6.0);
        this.aMap.addBidirectionalLink("B", "D", 4.0);
        this.aMap.addBidirectionalLink("B", "E", 7.0);
        this.aMap.addBidirectionalLink("D", "F", 4.0);
        this.aMap.addBidirectionalLink("D", "G", 8.0);
        this.envChanges = new StringBuffer();
    }

    public void testAlreadyAtGoal() {
        MapEnvironment mapEnvironment = new MapEnvironment(this.aMap);
        OnlineDFSAgent onlineDFSAgent = new OnlineDFSAgent(new BidirectionalMapProblem(mapEnvironment.getMap(), "A", "A"));
        mapEnvironment.addAgent(onlineDFSAgent, "A");
        mapEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                OnlineDFSAgentTest.this.envChanges.append(string).append("->");
            }
        });
        mapEnvironment.stepUntilDone();
        OnlineDFSAgentTest.assertEquals((String)"NoOP->", (String)this.envChanges.toString());
    }

    public void testNormalSearch() {
        MapEnvironment mapEnvironment = new MapEnvironment(this.aMap);
        OnlineDFSAgent onlineDFSAgent = new OnlineDFSAgent(new BidirectionalMapProblem(mapEnvironment.getMap(), "A", "G"));
        mapEnvironment.addAgent(onlineDFSAgent, "A");
        mapEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                OnlineDFSAgentTest.this.envChanges.append(string).append("->");
            }
        });
        mapEnvironment.stepUntilDone();
        OnlineDFSAgentTest.assertEquals((String)"C->A->B->E->B->D->G->NoOP->", (String)this.envChanges.toString());
    }

    public void testNoPath() {
    }

    public void testFig4_18() {
        this.aMap = new ExtendableMap();
        this.aMap.addBidirectionalLink("1,1", "1,2", 1.0);
        this.aMap.addBidirectionalLink("1,1", "2,1", 1.0);
        this.aMap.addBidirectionalLink("1,2", "1,3", 1.0);
        this.aMap.addBidirectionalLink("1,2", "2,2", 1.0);
        this.aMap.addBidirectionalLink("1,3", "2,3", 1.0);
        this.aMap.addBidirectionalLink("2,2", "3,2", 1.0);
        this.aMap.addBidirectionalLink("2,3", "3,3", 1.0);
        this.aMap.addBidirectionalLink("3,1", "3,2", 1.0);
        MapEnvironment mapEnvironment = new MapEnvironment(this.aMap);
        OnlineDFSAgent onlineDFSAgent = new OnlineDFSAgent(new BidirectionalMapProblem(mapEnvironment.getMap(), "1,1", "3,3"));
        mapEnvironment.addAgent(onlineDFSAgent, "1,1");
        mapEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                OnlineDFSAgentTest.this.envChanges.append(string).append("->");
            }
        });
        mapEnvironment.stepUntilDone();
        OnlineDFSAgentTest.assertEquals((String)"2,1->1,1->1,2->2,2->3,2->3,1->3,2->2,2->1,2->1,3->2,3->3,3->NoOP->", (String)this.envChanges.toString());
    }
}

