/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.online;

import aima.basic.BasicEnvironmentView;
import aima.search.framework.HeuristicFunction;
import aima.search.map.BidirectionalMapProblem;
import aima.search.map.ExtendableMap;
import aima.search.map.MapEnvironment;
import aima.search.online.LRTAStarAgent;
import junit.framework.TestCase;

public class LRTAStarAgentTest
extends TestCase {
    ExtendableMap aMap;
    StringBuffer envChanges;
    HeuristicFunction hf;

    public void setUp() {
        this.aMap = new ExtendableMap();
        this.aMap.addBidirectionalLink("A", "B", 4.0);
        this.aMap.addBidirectionalLink("B", "C", 4.0);
        this.aMap.addBidirectionalLink("C", "D", 4.0);
        this.aMap.addBidirectionalLink("D", "E", 4.0);
        this.aMap.addBidirectionalLink("E", "F", 4.0);
        this.hf = new HeuristicFunction(){

            @Override
            public double getHeuristicValue(Object object) {
                return 1.0;
            }
        };
        this.envChanges = new StringBuffer();
    }

    public void testAlreadyAtGoal() {
        MapEnvironment mapEnvironment = new MapEnvironment(this.aMap);
        LRTAStarAgent lRTAStarAgent = new LRTAStarAgent(new BidirectionalMapProblem(mapEnvironment.getMap(), "A", "A", this.hf));
        mapEnvironment.addAgent(lRTAStarAgent, "A");
        mapEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                LRTAStarAgentTest.this.envChanges.append(string).append("->");
            }
        });
        mapEnvironment.stepUntilDone();
        LRTAStarAgentTest.assertEquals((String)"NoOP->", (String)this.envChanges.toString());
    }

    public void testNormalSearch() {
        MapEnvironment mapEnvironment = new MapEnvironment(this.aMap);
        LRTAStarAgent lRTAStarAgent = new LRTAStarAgent(new BidirectionalMapProblem(mapEnvironment.getMap(), "A", "F", this.hf));
        mapEnvironment.addAgent(lRTAStarAgent, "A");
        mapEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                LRTAStarAgentTest.this.envChanges.append(string).append("->");
            }
        });
        mapEnvironment.stepUntilDone();
        LRTAStarAgentTest.assertEquals((String)"B->A->B->C->B->C->D->C->D->E->D->E->F->NoOP->", (String)this.envChanges.toString());
    }

    public void testNoPath() {
    }
}

