/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search;

import aima.util.AbstractQueue;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class QueueTest
extends TestCase {
    private AbstractQueue queue;

    public void setUp() {
        this.queue = new AbstractQueue();
    }

    public void testInitialization() {
        QueueTest.assertEquals((int)0, (int)this.queue.size());
        QueueTest.assertTrue((boolean)this.queue.isEmpty());
    }

    public void testGetFirst() {
        this.queue.addToFront("Hello");
        QueueTest.assertEquals((int)1, (int)this.queue.size());
        QueueTest.assertFalse((boolean)this.queue.isEmpty());
        String string = (String)this.queue.getFirst();
        QueueTest.assertEquals((String)"Hello", (String)string);
        QueueTest.assertFalse((boolean)this.queue.isEmpty());
    }

    public void testRemoveFirst() {
        this.queue.addToFront("Hello");
        QueueTest.assertEquals((int)1, (int)this.queue.size());
        QueueTest.assertFalse((boolean)this.queue.isEmpty());
        String string = (String)this.queue.removeFirst();
        QueueTest.assertEquals((String)"Hello", (String)string);
        QueueTest.assertTrue((boolean)this.queue.isEmpty());
    }

    public void testGetLast() {
        this.queue.addToFront("Hello");
        QueueTest.assertEquals((int)1, (int)this.queue.size());
        QueueTest.assertFalse((boolean)this.queue.isEmpty());
        String string = (String)this.queue.getLast();
        QueueTest.assertEquals((String)"Hello", (String)string);
        QueueTest.assertFalse((boolean)this.queue.isEmpty());
    }

    public void testRemoveLast() {
        this.queue.addToFront("Hello");
        QueueTest.assertEquals((int)1, (int)this.queue.size());
        QueueTest.assertFalse((boolean)this.queue.isEmpty());
        String string = (String)this.queue.removeLast();
        QueueTest.assertEquals((String)"Hello", (String)string);
        QueueTest.assertTrue((boolean)this.queue.isEmpty());
    }

    public void testAddToFront() {
        this.queue.addToFront("Hello");
        QueueTest.assertEquals((int)1, (int)this.queue.size());
        QueueTest.assertFalse((boolean)this.queue.isEmpty());
        this.queue.addToFront("Hi");
        QueueTest.assertEquals((int)2, (int)this.queue.size());
        QueueTest.assertFalse((boolean)this.queue.isEmpty());
        String string = (String)this.queue.removeFirst();
        QueueTest.assertEquals((String)"Hi", (String)string);
        QueueTest.assertEquals((int)1, (int)this.queue.size());
        QueueTest.assertEquals((Object)"Hello", (Object)this.queue.getFirst());
    }

    public void testAddToBack() {
        this.queue.addToBack("Hello");
        QueueTest.assertEquals((int)1, (int)this.queue.size());
        QueueTest.assertFalse((boolean)this.queue.isEmpty());
        this.queue.addToBack("Hi");
        QueueTest.assertEquals((int)2, (int)this.queue.size());
        QueueTest.assertFalse((boolean)this.queue.isEmpty());
        String string = (String)this.queue.removeFirst();
        QueueTest.assertEquals((String)"Hello", (String)string);
        QueueTest.assertEquals((int)1, (int)this.queue.size());
        QueueTest.assertEquals((Object)"Hi", (Object)this.queue.getFirst());
    }

    public void testMultipleAddToFront() {
        this.queue.addToFront("Hello");
        QueueTest.assertEquals((int)1, (int)this.queue.size());
        QueueTest.assertFalse((boolean)this.queue.isEmpty());
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Hi");
        arrayList.add("Bye");
        this.queue.addToFront(arrayList);
        QueueTest.assertEquals((int)3, (int)this.queue.size());
        String string = (String)this.queue.removeFirst();
        QueueTest.assertEquals((String)"Hi", (String)string);
        QueueTest.assertEquals((int)2, (int)this.queue.size());
        QueueTest.assertEquals((Object)"Bye", (Object)this.queue.getFirst());
    }

    public void testMultipleAddToBack() {
        this.queue.addToFront("Hello");
        QueueTest.assertEquals((int)1, (int)this.queue.size());
        QueueTest.assertFalse((boolean)this.queue.isEmpty());
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Hi");
        arrayList.add("Bye");
        this.queue.addToBack(arrayList);
        QueueTest.assertEquals((int)3, (int)this.queue.size());
        String string = (String)this.queue.removeFirst();
        QueueTest.assertEquals((String)"Hello", (String)string);
        QueueTest.assertEquals((int)2, (int)this.queue.size());
        QueueTest.assertEquals((Object)"Hi", (Object)this.queue.getFirst());
    }

    public void testAsList() {
        this.queue.addToFront("Hello");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Hi");
        arrayList.add("Bye");
        this.queue.addToBack(arrayList);
        QueueTest.assertEquals((int)3, (int)this.queue.size());
        List list = this.queue.asList();
        QueueTest.assertEquals((int)3, (int)list.size());
    }

    public void testExceptions() {
        try {
            this.queue.add("Hello");
            QueueTest.fail((String)"Runtime Exception should have been thrown");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            this.queue.remove();
            QueueTest.fail((String)"Runtime Exception should have been thrown");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            this.queue.get();
            QueueTest.fail((String)"Runtime Exception should have been thrown");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        ArrayList arrayList = new ArrayList();
        try {
            this.queue.add(arrayList);
            QueueTest.fail((String)"Runtime Exception should have been thrown");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

