/*
 * Decompiled with CFR 0.152.
 */
package aima.test.probreasoningtest;

import aima.probability.RandomVariable;
import aima.probability.reasoning.FixedLagSmoothing;
import aima.probability.reasoning.HMMFactory;
import aima.probability.reasoning.HiddenMarkovModel;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class HMMTest
extends TestCase {
    private HiddenMarkovModel robotHmm;
    private HiddenMarkovModel rainmanHmm;
    private static final double TOLERANCE = 0.001;

    public void setUp() {
        this.robotHmm = HMMFactory.createRobotHMM();
        this.rainmanHmm = HMMFactory.createRainmanHMM();
    }

    public void testRobotHMMInitialization() {
        HMMTest.assertEquals((Object)0.5, (Object)this.robotHmm.prior().getProbabilityOf("open"));
        HMMTest.assertEquals((Object)0.5, (Object)this.robotHmm.prior().getProbabilityOf("closed"));
    }

    public void testRainmanHmmInitialization() {
        HMMTest.assertEquals((Object)0.5, (Object)this.rainmanHmm.prior().getProbabilityOf("rain"));
        HMMTest.assertEquals((Object)0.5, (Object)this.rainmanHmm.prior().getProbabilityOf("no_rain"));
    }

    public void testForwardMessagingWorksForFiltering() {
        RandomVariable randomVariable = this.robotHmm.forward(this.robotHmm.prior(), "do_nothing", "see_open");
        HMMTest.assertEquals((double)0.75, (double)randomVariable.getProbabilityOf("open"), (double)0.001);
        HMMTest.assertEquals((double)0.25, (double)randomVariable.getProbabilityOf("closed"), (double)0.001);
        RandomVariable randomVariable2 = this.robotHmm.forward(randomVariable, "push", "see_open");
        HMMTest.assertEquals((double)0.983, (double)randomVariable2.getProbabilityOf("open"), (double)0.001);
        HMMTest.assertEquals((double)0.017, (double)randomVariable2.getProbabilityOf("closed"), (double)0.001);
    }

    public void testRecursiveBackwardMessageCalculationIsCorrect() {
        RandomVariable randomVariable = this.rainmanHmm.forward(this.rainmanHmm.prior(), "do_nothing", "carries_umbrella");
        RandomVariable randomVariable2 = this.rainmanHmm.forward(randomVariable, "do_nothing", "carries_umbrella");
        RandomVariable randomVariable3 = randomVariable2.duplicate().createUnitBelief();
        RandomVariable randomVariable4 = this.rainmanHmm.calculate_next_backward_message(randomVariable, randomVariable3, "carries_umbrella");
        HMMTest.assertEquals((double)0.883, (double)randomVariable4.getProbabilityOf("rain"), (double)0.001);
        HMMTest.assertEquals((double)0.117, (double)randomVariable4.getProbabilityOf("no_rain"), (double)0.001);
    }

    public void testForwardBackwardOnRainmanHmm() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("carries_umbrella");
        arrayList.add("carries_umbrella");
        List<RandomVariable> list = this.rainmanHmm.forward_backward(arrayList);
        HMMTest.assertEquals((int)3, (int)list.size());
        HMMTest.assertNull((Object)list.get(0));
        RandomVariable randomVariable = list.get(1);
        HMMTest.assertEquals((double)0.982, (double)randomVariable.getProbabilityOf("rain"), (double)0.001);
        HMMTest.assertEquals((double)0.018, (double)randomVariable.getProbabilityOf("no_rain"), (double)0.001);
        RandomVariable randomVariable2 = list.get(2);
        HMMTest.assertEquals((double)0.883, (double)randomVariable2.getProbabilityOf("rain"), (double)0.001);
        HMMTest.assertEquals((double)0.117, (double)randomVariable2.getProbabilityOf("no_rain"), (double)0.001);
    }

    public void testForwardBackwardOnRainmanHmmFor3daysData() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("carries_umbrella");
        arrayList.add("carries_umbrella");
        arrayList.add("does_not_carry_umbrella");
        List<RandomVariable> list = this.rainmanHmm.forward_backward(arrayList);
        HMMTest.assertEquals((int)4, (int)list.size());
        HMMTest.assertNull((Object)list.get(0));
        RandomVariable randomVariable = list.get(1);
        HMMTest.assertEquals((double)0.964, (double)randomVariable.getProbabilityOf("rain"), (double)0.001);
        HMMTest.assertEquals((double)0.036, (double)randomVariable.getProbabilityOf("no_rain"), (double)0.001);
        RandomVariable randomVariable2 = list.get(2);
        HMMTest.assertEquals((double)0.484, (double)randomVariable2.getProbabilityOf("rain"), (double)0.001);
        HMMTest.assertEquals((double)0.516, (double)randomVariable2.getProbabilityOf("no_rain"), (double)0.001);
        RandomVariable randomVariable3 = list.get(3);
        HMMTest.assertEquals((double)0.19, (double)randomVariable3.getProbabilityOf("rain"), (double)0.001);
        HMMTest.assertEquals((double)0.81, (double)randomVariable3.getProbabilityOf("no_rain"), (double)0.001);
    }

    public void xtestForwardBackwardAndFixedLagSmoothingGiveSameResults() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "carries_umbrella";
        String string2 = "carries_umbrella";
        String string3 = "does_not_carry_umbrella";
        arrayList.add(string);
        arrayList.add(string2);
        arrayList.add(string3);
        List<RandomVariable> list = this.rainmanHmm.forward_backward(arrayList);
        HMMTest.assertEquals((int)4, (int)list.size());
        RandomVariable randomVariable = list.get(1);
        System.out.println(randomVariable);
        FixedLagSmoothing fixedLagSmoothing = new FixedLagSmoothing(this.rainmanHmm, 2);
        HMMTest.assertNull((Object)fixedLagSmoothing.smooth(string));
        System.out.println(fixedLagSmoothing.smooth(string2));
        RandomVariable randomVariable2 = fixedLagSmoothing.smooth(string3);
        System.out.println(randomVariable2);
    }

    public void testOneStepFixedLagSmoothingOnRainManHmm() {
        FixedLagSmoothing fixedLagSmoothing = new FixedLagSmoothing(this.rainmanHmm, 1);
        RandomVariable randomVariable = fixedLagSmoothing.smooth("carries_umbrella");
        HMMTest.assertEquals((double)0.627, (double)randomVariable.getProbabilityOf("rain"), (double)0.001);
        RandomVariable randomVariable2 = fixedLagSmoothing.smooth("carries_umbrella");
        HMMTest.assertEquals((double)0.883, (double)randomVariable2.getProbabilityOf("rain"), (double)0.001);
        HMMTest.assertEquals((double)0.117, (double)randomVariable2.getProbabilityOf("no_rain"), (double)0.001);
        RandomVariable randomVariable3 = fixedLagSmoothing.smooth("does_not_carry_umbrella");
        HMMTest.assertEquals((double)0.799, (double)randomVariable3.getProbabilityOf("rain"), (double)0.001);
        HMMTest.assertEquals((double)0.201, (double)randomVariable3.getProbabilityOf("no_rain"), (double)0.001);
    }

    public void testOneStepFixedLagSmoothingOnRainManHmmWithDifferingEvidence() {
        FixedLagSmoothing fixedLagSmoothing = new FixedLagSmoothing(this.rainmanHmm, 1);
        RandomVariable randomVariable = fixedLagSmoothing.smooth("carries_umbrella");
        HMMTest.assertEquals((double)0.627, (double)randomVariable.getProbabilityOf("rain"), (double)0.001);
        RandomVariable randomVariable2 = fixedLagSmoothing.smooth("does_not_carry_umbrella");
        HMMTest.assertEquals((double)0.702, (double)randomVariable2.getProbabilityOf("rain"), (double)0.001);
        HMMTest.assertEquals((double)0.297, (double)randomVariable2.getProbabilityOf("no_rain"), (double)0.001);
    }

    public void testTwoStepFixedLagSmoothingOnRainManHmm() {
        FixedLagSmoothing fixedLagSmoothing = new FixedLagSmoothing(this.rainmanHmm, 2);
        RandomVariable randomVariable = fixedLagSmoothing.smooth("carries_umbrella");
        HMMTest.assertNull((Object)randomVariable);
        randomVariable = fixedLagSmoothing.smooth("carries_umbrella");
        HMMTest.assertEquals((double)0.653, (double)randomVariable.getProbabilityOf("rain"), (double)0.001);
        HMMTest.assertEquals((double)0.346, (double)randomVariable.getProbabilityOf("no_rain"), (double)0.001);
        RandomVariable randomVariable2 = fixedLagSmoothing.smooth("carries_umbrella");
        HMMTest.assertEquals((double)0.894, (double)randomVariable2.getProbabilityOf("rain"), (double)0.001);
        HMMTest.assertEquals((double)0.105, (double)randomVariable2.getProbabilityOf("no_rain"), (double)0.001);
    }
}

