/*
 * Decompiled with CFR 0.152.
 */
package aima.test.probdecisiontest;

import aima.probability.Randomizer;
import aima.probability.decision.MDPTransitionModel;
import aima.probability.decision.MDPUtilityFunction;
import aima.probability.decision.cellworld.CellWorld;
import aima.probability.decision.cellworld.CellWorldPosition;
import aima.test.probabilitytest.MockRandomizer;
import aima.util.Pair;
import junit.framework.TestCase;

public class CellWorldTest
extends TestCase {
    private CellWorld cw;
    private Randomizer alwaysLessThanEightyPercent;
    private Randomizer betweenEightyAndNinetyPercent;
    private Randomizer greaterThanNinetyPercent;

    public void setUp() {
        this.cw = new CellWorld(3, 4, -0.04);
        this.cw.markBlocked(2, 2);
        this.cw.setTerminalState(2, 4);
        this.cw.setReward(2, 4, -1.0);
        this.cw.setTerminalState(3, 4);
        this.cw.setReward(3, 4, 1.0);
        this.alwaysLessThanEightyPercent = new MockRandomizer(new double[]{0.7});
        this.betweenEightyAndNinetyPercent = new MockRandomizer(new double[]{0.85});
        this.greaterThanNinetyPercent = new MockRandomizer(new double[]{0.95});
    }

    public void testMoveLeftIntoWallLeavesPositionUnchanged() {
        CellWorldPosition cellWorldPosition = this.cw.moveProbabilisticallyFrom(1, 1, "left", this.alwaysLessThanEightyPercent);
        CellWorldTest.assertEquals((int)1, (int)cellWorldPosition.getX());
        CellWorldTest.assertEquals((int)1, (int)cellWorldPosition.getY());
    }

    public void testMoveLeftIntoUnblockedCellChangesPositionCorrectly() {
        CellWorldPosition cellWorldPosition = this.cw.moveProbabilisticallyFrom(1, 2, "left", this.alwaysLessThanEightyPercent);
        CellWorldTest.assertEquals((int)1, (int)cellWorldPosition.getX());
        CellWorldTest.assertEquals((int)1, (int)cellWorldPosition.getY());
    }

    public void testMoveLeftIntoUnblockedCellActuallyMovesUpWhenProbabilityBetween80And90Percent() {
        CellWorldPosition cellWorldPosition = this.cw.moveProbabilisticallyFrom(1, 4, "left", this.betweenEightyAndNinetyPercent);
        CellWorldTest.assertEquals((int)2, (int)cellWorldPosition.getX());
        CellWorldTest.assertEquals((int)4, (int)cellWorldPosition.getY());
    }

    public void testMoveLeftIntoUnblockedCellActuallyMovesDownWhenProbabilityGreaterThan90Percent() {
        CellWorldPosition cellWorldPosition = this.cw.moveProbabilisticallyFrom(3, 3, "left", this.greaterThanNinetyPercent);
        CellWorldTest.assertEquals((int)2, (int)cellWorldPosition.getX());
        CellWorldTest.assertEquals((int)3, (int)cellWorldPosition.getY());
    }

    public void testMoveLeftIntoBlockedCellLeavesPositionUnchanged() {
        CellWorldPosition cellWorldPosition = this.cw.moveProbabilisticallyFrom(2, 3, "left", this.alwaysLessThanEightyPercent);
        CellWorldTest.assertEquals((int)2, (int)cellWorldPosition.getX());
        CellWorldTest.assertEquals((int)3, (int)cellWorldPosition.getY());
    }

    public void testMoveRightIntoWallLeavesPositionUnchanged() {
        CellWorldPosition cellWorldPosition = this.cw.moveProbabilisticallyFrom(1, 4, "right", this.alwaysLessThanEightyPercent);
        CellWorldTest.assertEquals((int)1, (int)cellWorldPosition.getX());
        CellWorldTest.assertEquals((int)4, (int)cellWorldPosition.getY());
    }

    public void testMoveRightIntoUnblockedCellChangesPositionCorrectly() {
        CellWorldPosition cellWorldPosition = this.cw.moveProbabilisticallyFrom(1, 2, "right", this.alwaysLessThanEightyPercent);
        CellWorldTest.assertEquals((int)1, (int)cellWorldPosition.getX());
        CellWorldTest.assertEquals((int)3, (int)cellWorldPosition.getY());
    }

    public void testMoveRightIntoBlockedCellLeavesPositionUnchanged() {
        CellWorldPosition cellWorldPosition = this.cw.moveProbabilisticallyFrom(2, 1, "right", this.alwaysLessThanEightyPercent);
        CellWorldTest.assertEquals((int)2, (int)cellWorldPosition.getX());
        CellWorldTest.assertEquals((int)1, (int)cellWorldPosition.getY());
    }

    public void testMoveRightIntoUnblockedCellActuallyMovesUpWhenProbabilityBetween80And90Percent() {
        CellWorldPosition cellWorldPosition = this.cw.moveProbabilisticallyFrom(1, 1, "right", this.betweenEightyAndNinetyPercent);
        CellWorldTest.assertEquals((int)2, (int)cellWorldPosition.getX());
        CellWorldTest.assertEquals((int)1, (int)cellWorldPosition.getY());
    }

    public void testMoveRightIntoUnblockedCellActuallyMovesDownWhenProbabilityGreaterThan90Percent() {
        CellWorldPosition cellWorldPosition = this.cw.moveProbabilisticallyFrom(3, 3, "right", this.greaterThanNinetyPercent);
        CellWorldTest.assertEquals((int)2, (int)cellWorldPosition.getX());
        CellWorldTest.assertEquals((int)3, (int)cellWorldPosition.getY());
    }

    public void testMoveUpIntoWallLeavesPositionUnchanged() {
        CellWorldPosition cellWorldPosition = this.cw.moveProbabilisticallyFrom(3, 1, "up", this.alwaysLessThanEightyPercent);
        CellWorldTest.assertEquals((int)3, (int)cellWorldPosition.getX());
        CellWorldTest.assertEquals((int)1, (int)cellWorldPosition.getY());
    }

    public void testMoveUpIntoUnblockedCellChangesPositionCorrectly() {
        CellWorldPosition cellWorldPosition = this.cw.moveProbabilisticallyFrom(1, 1, "up", this.alwaysLessThanEightyPercent);
        CellWorldTest.assertEquals((int)2, (int)cellWorldPosition.getX());
        CellWorldTest.assertEquals((int)1, (int)cellWorldPosition.getY());
    }

    public void testMoveUpIntoBlockedCellLeavesPositionUnchanged() {
        CellWorldPosition cellWorldPosition = this.cw.moveProbabilisticallyFrom(1, 2, "up", this.alwaysLessThanEightyPercent);
        CellWorldTest.assertEquals((int)1, (int)cellWorldPosition.getX());
        CellWorldTest.assertEquals((int)2, (int)cellWorldPosition.getY());
    }

    public void testMoveUpActuallyMovesLeftWhenProbabilityBetween80And90Percent() {
        CellWorldPosition cellWorldPosition = this.cw.moveProbabilisticallyFrom(1, 4, "up", this.betweenEightyAndNinetyPercent);
        CellWorldTest.assertEquals((int)1, (int)cellWorldPosition.getX());
        CellWorldTest.assertEquals((int)3, (int)cellWorldPosition.getY());
    }

    public void testMoveUpActuallyMovesRightWhenProbabilityGreaterThan90Percent() {
        CellWorldPosition cellWorldPosition = this.cw.moveProbabilisticallyFrom(1, 3, "up", this.greaterThanNinetyPercent);
        CellWorldTest.assertEquals((int)1, (int)cellWorldPosition.getX());
        CellWorldTest.assertEquals((int)4, (int)cellWorldPosition.getY());
    }

    public void testMoveDownIntoWallLeavesPositionUnchanged() {
        CellWorldPosition cellWorldPosition = this.cw.moveProbabilisticallyFrom(1, 1, "down", this.alwaysLessThanEightyPercent);
        CellWorldTest.assertEquals((int)1, (int)cellWorldPosition.getX());
        CellWorldTest.assertEquals((int)1, (int)cellWorldPosition.getY());
    }

    public void testMoveDownIntoUnblockedCellChangesPositionCorrectly() {
        CellWorldPosition cellWorldPosition = this.cw.moveProbabilisticallyFrom(2, 1, "down", this.alwaysLessThanEightyPercent);
        CellWorldTest.assertEquals((int)1, (int)cellWorldPosition.getX());
        CellWorldTest.assertEquals((int)1, (int)cellWorldPosition.getY());
    }

    public void testMoveDownIntoBlockedCellLeavesPositionUnchanged() {
        CellWorldPosition cellWorldPosition = this.cw.moveProbabilisticallyFrom(3, 2, "up", this.alwaysLessThanEightyPercent);
        CellWorldTest.assertEquals((int)3, (int)cellWorldPosition.getX());
        CellWorldTest.assertEquals((int)2, (int)cellWorldPosition.getY());
    }

    public void testMoveDownActuallyMovesLeftWhenProbabilityBetween80And90Percent() {
        CellWorldPosition cellWorldPosition = this.cw.moveProbabilisticallyFrom(3, 3, "down", this.betweenEightyAndNinetyPercent);
        CellWorldTest.assertEquals((int)3, (int)cellWorldPosition.getX());
        CellWorldTest.assertEquals((int)2, (int)cellWorldPosition.getY());
    }

    public void testMoveDownActuallyMovesRightWhenProbabilityGreaterThan90Percent() {
        CellWorldPosition cellWorldPosition = this.cw.moveProbabilisticallyFrom(2, 3, "up", this.greaterThanNinetyPercent);
        CellWorldTest.assertEquals((int)2, (int)cellWorldPosition.getX());
        CellWorldTest.assertEquals((int)4, (int)cellWorldPosition.getY());
    }

    public void testNumberOfUnBlockedCells() {
        CellWorldTest.assertEquals((int)11, (int)this.cw.unblockedCells().size());
    }

    public void testMoveFromATerminalStateFailsForAllProbabilityValues() {
        CellWorldPosition cellWorldPosition = this.cw.moveProbabilisticallyFrom(2, 4, "up", this.alwaysLessThanEightyPercent);
        CellWorldTest.assertEquals((int)2, (int)cellWorldPosition.getX());
        CellWorldTest.assertEquals((int)4, (int)cellWorldPosition.getY());
    }

    public void testTransitionProbabilityCalculationWhenEndingPositionIsNextToStartingPositionButIsBlocked() {
        CellWorldPosition cellWorldPosition = new CellWorldPosition(2, 1);
        CellWorldPosition cellWorldPosition2 = new CellWorldPosition(2, 2);
        double d = this.cw.getTransitionProbability(cellWorldPosition, "right", cellWorldPosition2);
        CellWorldTest.assertEquals((Object)0.0, (Object)d);
    }

    public void testTransitionProbabilityCalculationWhenEndingPositionCannotBeReachedUsingDesiredActionOrRightAngledSteps() {
        CellWorldPosition cellWorldPosition = new CellWorldPosition(1, 3);
        CellWorldPosition cellWorldPosition2 = new CellWorldPosition(3, 3);
        double d = this.cw.getTransitionProbability(cellWorldPosition, "up", cellWorldPosition2);
        CellWorldTest.assertEquals((Object)0.0, (Object)d);
    }

    public void testTransitionProbabilityCalculationWhenEndingPositionReachebleByExecutingSuggestedAction() {
        CellWorldPosition cellWorldPosition = new CellWorldPosition(1, 1);
        CellWorldPosition cellWorldPosition2 = new CellWorldPosition(2, 1);
        double d = this.cw.getTransitionProbability(cellWorldPosition, "up", cellWorldPosition2);
        CellWorldTest.assertEquals((Object)0.8, (Object)d);
    }

    public void testTransitionProbabilityCalculationWhenBothRightAngledActiosnLeadToStartingPosition() {
        CellWorldPosition cellWorldPosition = new CellWorldPosition(2, 1);
        CellWorldPosition cellWorldPosition2 = new CellWorldPosition(2, 1);
        double d = this.cw.getTransitionProbability(cellWorldPosition, "up", cellWorldPosition2);
        CellWorldTest.assertEquals((Object)0.2, (Object)d);
    }

    public void testTransitionModelCreation() {
        MDPTransitionModel<CellWorldPosition, String> mDPTransitionModel = this.cw.getTransitionModel();
        CellWorldPosition cellWorldPosition = new CellWorldPosition(1, 1);
        CellWorldPosition cellWorldPosition2 = new CellWorldPosition(2, 1);
        CellWorldTest.assertEquals((Object)0.8, (Object)mDPTransitionModel.getTransitionProbability(cellWorldPosition, "up", cellWorldPosition2));
        CellWorldPosition cellWorldPosition3 = new CellWorldPosition(1, 1);
        CellWorldTest.assertEquals((Object)0.1, (Object)mDPTransitionModel.getTransitionProbability(cellWorldPosition, "up", cellWorldPosition3));
        CellWorldPosition cellWorldPosition4 = new CellWorldPosition(1, 2);
        CellWorldTest.assertEquals((Object)0.1, (Object)mDPTransitionModel.getTransitionProbability(cellWorldPosition, "up", cellWorldPosition4));
    }

    public void testCannotTransitionFromFinalState() {
        MDPTransitionModel<CellWorldPosition, String> mDPTransitionModel = this.cw.getTransitionModel();
        CellWorldPosition cellWorldPosition = new CellWorldPosition(2, 4);
        CellWorldPosition cellWorldPosition2 = new CellWorldPosition(3, 4);
        CellWorldTest.assertEquals((Object)0.0, (Object)mDPTransitionModel.getTransitionProbability(cellWorldPosition, "up", cellWorldPosition2));
        CellWorldTest.assertEquals((Object)0.0, (Object)mDPTransitionModel.getTransitionProbability(cellWorldPosition2, "down", cellWorldPosition));
    }

    public void testMaximumTransitionDetection() {
        MDPTransitionModel<CellWorldPosition, String> mDPTransitionModel = this.cw.getTransitionModel();
        MDPUtilityFunction<CellWorldPosition> mDPUtilityFunction = new MDPUtilityFunction<CellWorldPosition>();
        mDPUtilityFunction.setUtility(new CellWorldPosition(1, 1), 0.705);
        mDPUtilityFunction.setUtility(new CellWorldPosition(1, 2), 0.655);
        mDPUtilityFunction.setUtility(new CellWorldPosition(1, 3), 0.611);
        mDPUtilityFunction.setUtility(new CellWorldPosition(1, 4), 0.388);
        mDPUtilityFunction.setUtility(new CellWorldPosition(2, 1), 0.762);
        mDPUtilityFunction.setUtility(new CellWorldPosition(2, 3), 0.66);
        mDPUtilityFunction.setUtility(new CellWorldPosition(2, 4), -1.0);
        mDPUtilityFunction.setUtility(new CellWorldPosition(3, 1), 0.812);
        mDPUtilityFunction.setUtility(new CellWorldPosition(3, 2), 0.868);
        mDPUtilityFunction.setUtility(new CellWorldPosition(3, 3), 0.918);
        mDPUtilityFunction.setUtility(new CellWorldPosition(3, 4), 1.0);
        this.assertPolicyReccomends(this.cw, mDPUtilityFunction, 1, 1, "up");
        this.assertPolicyReccomends(this.cw, mDPUtilityFunction, 1, 2, "left");
        this.assertPolicyReccomends(this.cw, mDPUtilityFunction, 1, 3, "left");
        this.assertPolicyReccomends(this.cw, mDPUtilityFunction, 1, 4, "left");
        this.assertPolicyReccomends(this.cw, mDPUtilityFunction, 2, 1, "up");
        this.assertPolicyReccomends(this.cw, mDPUtilityFunction, 2, 3, "up");
        this.assertPolicyReccomends(this.cw, mDPUtilityFunction, 2, 4, null);
        this.assertPolicyReccomends(this.cw, mDPUtilityFunction, 3, 1, "right");
        this.assertPolicyReccomends(this.cw, mDPUtilityFunction, 3, 2, "right");
        this.assertPolicyReccomends(this.cw, mDPUtilityFunction, 3, 3, "right");
        this.assertPolicyReccomends(this.cw, mDPUtilityFunction, 3, 4, null);
    }

    private void assertPolicyReccomends(CellWorld cellWorld, MDPUtilityFunction<CellWorldPosition> mDPUtilityFunction, int n, int n2, String string) {
        Pair<String, Double> pair = cellWorld.getTransitionModel().getTransitionWithMaximumExpectedUtility(new CellWorldPosition(n, n2), mDPUtilityFunction);
        CellWorldTest.assertEquals((String)string, (String)pair.getFirst());
    }
}

