/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.foltest;

import aima.logic.fol.CNFConverter;
import aima.logic.fol.domain.FOLDomain;
import aima.logic.fol.inference.FOLOTTERLikeTheoremProver;
import aima.logic.fol.inference.InferenceResult;
import aima.logic.fol.inference.otter.defaultimpl.DefaultClauseSimplifier;
import aima.logic.fol.kb.FOLKnowledgeBase;
import aima.logic.fol.kb.data.CNF;
import aima.logic.fol.kb.data.Clause;
import aima.logic.fol.parsing.FOLParser;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.TermEquality;
import aima.test.logictest.foltest.CommonFOLInferenceProcedureTests;
import java.util.ArrayList;
import junit.framework.Assert;

public class FOLOTTERLikeTheoremProverTest
extends CommonFOLInferenceProcedureTests {
    public void testDefaultClauseSimplifier() {
        FOLDomain fOLDomain = new FOLDomain();
        fOLDomain.addConstant("ZERO");
        fOLDomain.addConstant("ONE");
        fOLDomain.addPredicate("P");
        fOLDomain.addFunction("Plus");
        fOLDomain.addFunction("Power");
        FOLParser fOLParser = new FOLParser(fOLDomain);
        ArrayList<TermEquality> arrayList = new ArrayList<TermEquality>();
        arrayList.add((TermEquality)fOLParser.parse("Plus(x, ZERO) = x"));
        arrayList.add((TermEquality)fOLParser.parse("Plus(ZERO, x) = x"));
        arrayList.add((TermEquality)fOLParser.parse("Power(x, ONE) = x"));
        arrayList.add((TermEquality)fOLParser.parse("Power(x, ZERO) = ONE"));
        DefaultClauseSimplifier defaultClauseSimplifier = new DefaultClauseSimplifier(arrayList);
        Sentence sentence = fOLParser.parse("((P(Plus(y,ZERO),Plus(ZERO,y)) OR P(Power(y, ONE),Power(y,ZERO))) OR P(Power(y,ZERO),Plus(y,ZERO)))");
        CNFConverter cNFConverter = new CNFConverter(fOLParser);
        CNF cNF = cNFConverter.convertToCNF(sentence);
        FOLOTTERLikeTheoremProverTest.assertEquals((int)1, (int)cNF.getNumberOfClauses());
        Clause clause = defaultClauseSimplifier.simplify(cNF.getConjunctionOfClauses().get(0));
        FOLOTTERLikeTheoremProverTest.assertEquals((String)"[P(y,y), P(y,ONE), P(ONE,y)]", (String)clause.toString());
    }

    public void testExhaustsSearchSpace() {
        FOLDomain fOLDomain = new FOLDomain();
        fOLDomain.addPredicate("alternate");
        fOLDomain.addPredicate("bar");
        fOLDomain.addPredicate("fri_sat");
        fOLDomain.addPredicate("hungry");
        fOLDomain.addPredicate("patrons");
        fOLDomain.addPredicate("price");
        fOLDomain.addPredicate("raining");
        fOLDomain.addPredicate("reservation");
        fOLDomain.addPredicate("type");
        fOLDomain.addPredicate("wait_estimate");
        fOLDomain.addPredicate("will_wait");
        fOLDomain.addConstant("Some");
        fOLDomain.addConstant("Full");
        fOLDomain.addConstant("French");
        fOLDomain.addConstant("Thai");
        fOLDomain.addConstant("Burger");
        fOLDomain.addConstant("$");
        fOLDomain.addConstant("_30_60");
        fOLDomain.addConstant("X0");
        FOLParser fOLParser = new FOLParser(fOLDomain);
        String string = "patrons(v,Some)";
        String string2 = "patrons(v,Full) AND (hungry(v) AND type(v,French))";
        String string3 = "patrons(v,Full) AND (hungry(v) AND (type(v,Thai) AND fri_sat(v)))";
        String string4 = "patrons(v,Full) AND (hungry(v) AND type(v,Burger))";
        String string5 = "FORALL v (will_wait(v) <=> (" + string + " OR (" + string2 + " OR (" + string3 + " OR (" + string4 + ")))))";
        Sentence sentence = fOLParser.parse(string5);
        Sentence sentence2 = fOLParser.parse("(((((((((alternate(X0) AND NOT(bar(X0))) AND NOT(fri_sat(X0))) AND hungry(X0)) AND patrons(X0,Full)) AND price(X0,$)) AND NOT(raining(X0))) AND NOT(reservation(X0))) AND type(X0,Thai)) AND wait_estimate(X0,_30_60))");
        Sentence sentence3 = fOLParser.parse("will_wait(X0)");
        FOLKnowledgeBase fOLKnowledgeBase = new FOLKnowledgeBase(fOLDomain, new FOLOTTERLikeTheoremProver(false));
        fOLKnowledgeBase.tell(sentence);
        fOLKnowledgeBase.tell(sentence2);
        InferenceResult inferenceResult = fOLKnowledgeBase.ask(sentence3);
        Assert.assertFalse((boolean)inferenceResult.isTrue());
        Assert.assertTrue((boolean)inferenceResult.isPossiblyFalse());
        Assert.assertFalse((boolean)inferenceResult.isUnknownDueToTimeout());
        Assert.assertFalse((boolean)inferenceResult.isPartialResultDueToTimeout());
        Assert.assertEquals((int)0, (int)inferenceResult.getProofs().size());
    }

    public void testDefiniteClauseKBKingsQueryCriminalXFalse() {
        this.testDefiniteClauseKBKingsQueryCriminalXFalse(new FOLOTTERLikeTheoremProver(false));
    }

    public void testDefiniteClauseKBKingsQueryRichardEvilFalse() {
        this.testDefiniteClauseKBKingsQueryRichardEvilFalse(new FOLOTTERLikeTheoremProver(false));
    }

    public void testDefiniteClauseKBKingsQueryJohnEvilSucceeds() {
        this.testDefiniteClauseKBKingsQueryJohnEvilSucceeds(new FOLOTTERLikeTheoremProver(false));
    }

    public void testDefiniteClauseKBKingsQueryEvilXReturnsJohnSucceeds() {
        this.testDefiniteClauseKBKingsQueryEvilXReturnsJohnSucceeds(new FOLOTTERLikeTheoremProver(false));
    }

    public void testDefiniteClauseKBKingsQueryKingXReturnsJohnAndRichardSucceeds() {
        this.testDefiniteClauseKBKingsQueryKingXReturnsJohnAndRichardSucceeds(new FOLOTTERLikeTheoremProver(false));
    }

    public void testDefiniteClauseKBWeaponsQueryCriminalXReturnsWestSucceeds() {
        this.testDefiniteClauseKBWeaponsQueryCriminalXReturnsWestSucceeds(new FOLOTTERLikeTheoremProver(false));
    }

    public void testHornClauseKBRingOfThievesQuerySkisXReturnsNancyRedBertDrew() {
        this.testHornClauseKBRingOfThievesQuerySkisXReturnsNancyRedBertDrew(new FOLOTTERLikeTheoremProver(2000L, false));
    }

    public void testFullFOLKBLovesAnimalQueryKillsCuriosityTunaSucceeds() {
        this.testFullFOLKBLovesAnimalQueryKillsCuriosityTunaSucceeds(new FOLOTTERLikeTheoremProver(false), false);
    }

    public void testFullFOLKBLovesAnimalQueryNotKillsJackTunaSucceeds() {
        this.testFullFOLKBLovesAnimalQueryNotKillsJackTunaSucceeds(new FOLOTTERLikeTheoremProver(false), false);
    }

    public void testFullFOLKBLovesAnimalQueryKillsJackTunaFalse() {
        this.testFullFOLKBLovesAnimalQueryKillsJackTunaFalse(new FOLOTTERLikeTheoremProver(false), true);
    }

    public void testEqualityAxiomsKBabcAEqualsCSucceeds() {
        this.testEqualityAxiomsKBabcAEqualsCSucceeds(new FOLOTTERLikeTheoremProver(false));
    }

    public void testEqualityAndSubstitutionAxiomsKBabcdFFASucceeds() {
        this.testEqualityAndSubstitutionAxiomsKBabcdFFASucceeds(new FOLOTTERLikeTheoremProver(false));
    }

    public void testEqualityAndSubstitutionAxiomsKBabcdPDSucceeds() {
        this.xtestEqualityAndSubstitutionAxiomsKBabcdPDSucceeds(new FOLOTTERLikeTheoremProver(false));
    }

    public void testEqualityAndSubstitutionAxiomsKBabcdPFFASucceeds() {
        this.testEqualityAndSubstitutionAxiomsKBabcdPFFASucceeds(new FOLOTTERLikeTheoremProver(false), false);
    }

    public void testEqualityNoAxiomsKBabcAEqualsCSucceeds() {
        this.testEqualityNoAxiomsKBabcAEqualsCSucceeds(new FOLOTTERLikeTheoremProver(true), false);
    }

    public void testEqualityAndSubstitutionNoAxiomsKBabcdFFASucceeds() {
        this.testEqualityAndSubstitutionNoAxiomsKBabcdFFASucceeds(new FOLOTTERLikeTheoremProver(true), false);
    }

    public void testEqualityAndSubstitutionNoAxiomsKBabcdPDSucceeds() {
        this.testEqualityAndSubstitutionNoAxiomsKBabcdPDSucceeds(new FOLOTTERLikeTheoremProver(true), false);
    }

    public void testEqualityAndSubstitutionNoAxiomsKBabcdPFFASucceeds() {
        this.testEqualityAndSubstitutionNoAxiomsKBabcdPFFASucceeds(new FOLOTTERLikeTheoremProver(true), false);
    }
}

