/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.foltest;

import aima.logic.fol.StandardizeApartIndexicalFactory;
import aima.logic.fol.domain.DomainFactory;
import aima.logic.fol.kb.FOLKnowledgeBase;
import aima.logic.fol.kb.data.Clause;
import aima.logic.fol.kb.data.Literal;
import aima.logic.fol.parsing.ast.Predicate;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import junit.framework.TestCase;

public class FOLKnowledgeBaseTest
extends TestCase {
    private FOLKnowledgeBase weaponsKB;
    private FOLKnowledgeBase kingsKB;

    public void setUp() {
        StandardizeApartIndexicalFactory.flush();
        this.weaponsKB = new FOLKnowledgeBase(DomainFactory.weaponsDomain());
        this.kingsKB = new FOLKnowledgeBase(DomainFactory.kingsDomain());
    }

    public void testAddRuleAndFact() {
        this.weaponsKB.tell("(Missile(x) => Weapon(x))");
        FOLKnowledgeBaseTest.assertEquals((int)1, (int)this.weaponsKB.getNumberRules());
        this.weaponsKB.tell("American(West)");
        FOLKnowledgeBaseTest.assertEquals((int)1, (int)this.weaponsKB.getNumberRules());
        FOLKnowledgeBaseTest.assertEquals((int)1, (int)this.weaponsKB.getNumberFacts());
    }

    public void testAddComplexRule() {
        this.weaponsKB.tell("( (((American(x) AND Weapon(y)) AND Sells(x,y,z)) AND Hostile(z)) => Criminal(x))");
        FOLKnowledgeBaseTest.assertEquals((int)1, (int)this.weaponsKB.getNumberRules());
        this.weaponsKB.tell("American(West)");
        FOLKnowledgeBaseTest.assertEquals((int)1, (int)this.weaponsKB.getNumberRules());
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(new Variable("v0"));
        Clause clause = this.weaponsKB.getAllDefiniteClauseImplications().get(0);
        FOLKnowledgeBaseTest.assertNotNull((Object)clause);
        FOLKnowledgeBaseTest.assertEquals((boolean)true, (boolean)clause.isImplicationDefiniteClause());
        FOLKnowledgeBaseTest.assertEquals((Object)new Literal(new Predicate("Criminal", arrayList)), (Object)clause.getPositiveLiterals().get(0));
    }

    public void testFactNotAddedWhenAlreadyPresent() {
        this.kingsKB.tell("((King(x) AND Greedy(x)) => Evil(x))");
        this.kingsKB.tell("King(John)");
        this.kingsKB.tell("King(Richard)");
        this.kingsKB.tell("Greedy(John)");
        FOLKnowledgeBaseTest.assertEquals((int)1, (int)this.kingsKB.getNumberRules());
        FOLKnowledgeBaseTest.assertEquals((int)3, (int)this.kingsKB.getNumberFacts());
        this.kingsKB.tell("King(John)");
        this.kingsKB.tell("King(Richard)");
        this.kingsKB.tell("Greedy(John)");
        FOLKnowledgeBaseTest.assertEquals((int)1, (int)this.kingsKB.getNumberRules());
        FOLKnowledgeBaseTest.assertEquals((int)3, (int)this.kingsKB.getNumberFacts());
        this.kingsKB.tell("(((King(John))))");
        this.kingsKB.tell("(((King(Richard))))");
        this.kingsKB.tell("(((Greedy(John))))");
        FOLKnowledgeBaseTest.assertEquals((int)1, (int)this.kingsKB.getNumberRules());
        FOLKnowledgeBaseTest.assertEquals((int)3, (int)this.kingsKB.getNumberFacts());
    }
}

