/*
 * Decompiled with CFR 0.152.
 */
package aima.test.learningtest;

import aima.learning.framework.DataSet;
import aima.learning.framework.DataSetFactory;
import aima.learning.framework.Learner;
import aima.learning.inductive.DecisionTree;
import aima.learning.learners.AdaBoostLearner;
import aima.learning.learners.StumpLearner;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class EnsembleLearningTest
extends TestCase {
    private static final String UNABLE_TO_CLASSIFY = "Unable to Classify";
    private static final String YES = "Yes";

    public void testAdaBoostEnablesCollectionOfStumpsToClassifyDataSetAccurately() throws Exception {
        DataSet dataSet = DataSetFactory.getRestaurantDataSet();
        List<DecisionTree> list = DecisionTree.getStumpsFor(dataSet, YES, "No");
        ArrayList<Learner> arrayList = new ArrayList<Learner>();
        Object adaBoostLearner = list.iterator();
        while (adaBoostLearner.hasNext()) {
            DecisionTree object2;
            DecisionTree decisionTree = object2 = adaBoostLearner.next();
            StumpLearner stumpLearner = new StumpLearner(decisionTree, "No");
            arrayList.add(stumpLearner);
        }
        adaBoostLearner = new AdaBoostLearner(arrayList, dataSet);
        ((AdaBoostLearner)adaBoostLearner).train(dataSet);
        int[] nArray = ((AdaBoostLearner)adaBoostLearner).test(dataSet);
        EnsembleLearningTest.assertEquals((int)12, (int)nArray[0]);
        EnsembleLearningTest.assertEquals((int)0, (int)nArray[1]);
    }
}

