/*
 * Decompiled with CFR 0.152.
 */
package aima.test.learningtest;

import aima.learning.framework.DataSet;
import aima.learning.framework.DataSetFactory;
import aima.learning.framework.Example;
import aima.learning.inductive.DLTest;
import aima.learning.inductive.DLTestFactory;
import java.util.List;
import junit.framework.TestCase;

public class DLTestTestCase
extends TestCase {
    public void testDecisionList() throws Exception {
        DataSet dataSet = DataSetFactory.getRestaurantDataSet();
        List<DLTest> list = new DLTestFactory().createDLTestsWithAttributeCount(dataSet, 1);
        DLTestTestCase.assertEquals((int)26, (int)list.size());
    }

    public void testDLTestMatchSucceedsWithMatchedExample() throws Exception {
        DataSet dataSet = DataSetFactory.getRestaurantDataSet();
        Example example = dataSet.getExample(0);
        DLTest dLTest = new DLTest();
        dLTest.add("type", "French");
        DLTestTestCase.assertTrue((boolean)dLTest.matches(example));
    }

    public void testDLTestMatchFailsOnMismatchedExample() throws Exception {
        DataSet dataSet = DataSetFactory.getRestaurantDataSet();
        Example example = dataSet.getExample(0);
        DLTest dLTest = new DLTest();
        dLTest.add("type", "Thai");
        DLTestTestCase.assertFalse((boolean)dLTest.matches(example));
    }

    public void testDLTestMatchesEvenOnMismatchedTargetAttributeValue() throws Exception {
        DataSet dataSet = DataSetFactory.getRestaurantDataSet();
        Example example = dataSet.getExample(0);
        DLTest dLTest = new DLTest();
        dLTest.add("type", "French");
        DLTestTestCase.assertTrue((boolean)dLTest.matches(example));
    }

    public void testDLTestReturnsMatchedAndUnmatchedExamplesCorrectly() throws Exception {
        DataSet dataSet = DataSetFactory.getRestaurantDataSet();
        DLTest dLTest = new DLTest();
        dLTest.add("type", "Burger");
        DataSet dataSet2 = dLTest.matchedExamples(dataSet);
        DLTestTestCase.assertEquals((int)4, (int)dataSet2.size());
        DataSet dataSet3 = dLTest.unmatchedExamples(dataSet);
        DLTestTestCase.assertEquals((int)8, (int)dataSet3.size());
    }
}

