/*
 * Decompiled with CFR 0.152.
 */
package aima.test.gametest;

import aima.games.AlphaBeta;
import aima.games.GameState;
import aima.games.TicTacToe;
import aima.games.TicTacToeBoard;
import java.util.ArrayList;
import junit.framework.TestCase;

public class TicTacToeTest
extends TestCase {
    private TicTacToeBoard tb;

    public TicTacToeTest(String string) {
        super(string);
    }

    public void setUp() {
        this.tb = new TicTacToeBoard();
    }

    public void testCreation() {
        TicTacToe ticTacToe = new TicTacToe();
        TicTacToeTest.assertEquals((int)9, (int)ticTacToe.getMoves(ticTacToe.getState()).size());
        TicTacToeTest.assertEquals((String)"X", (String)ticTacToe.getPlayerToMove(ticTacToe.getState()));
    }

    public void testOnCreationBoardIsEmpty() {
        TicTacToeTest.assertEquals((boolean)true, (boolean)this.tb.isEmpty(0, 0));
        TicTacToeTest.assertEquals((boolean)true, (boolean)this.tb.isEmpty(0, 2));
        TicTacToeTest.assertEquals((boolean)true, (boolean)this.tb.isEmpty(2, 0));
        TicTacToeTest.assertEquals((boolean)true, (boolean)this.tb.isEmpty(2, 2));
    }

    public void testMovingBumpsLevelByOne() {
        TicTacToe ticTacToe = new TicTacToe();
        int n = ticTacToe.getLevel(ticTacToe.getState());
        TicTacToeTest.assertEquals((int)0, (int)n);
        ticTacToe.makeMove(0, 0);
        n = ticTacToe.getLevel(ticTacToe.getState());
        TicTacToeTest.assertEquals((int)1, (int)n);
    }

    public void testMarkingAsSquareMakesItNonEmpty() {
        this.tb.markX(0, 0);
        TicTacToeTest.assertEquals((boolean)false, (boolean)this.tb.isEmpty(0, 0));
    }

    public void testAllCombinationsOfSuccessLines() {
        this.tb.markX(0, 0);
        this.tb.markX(0, 1);
        this.tb.markX(0, 2);
        TicTacToeTest.assertEquals((boolean)true, (boolean)this.tb.isAnyRowComplete());
        this.tb.markO(0, 2);
        TicTacToeTest.assertEquals((boolean)false, (boolean)this.tb.isAnyRowComplete());
        this.tb.markO(1, 2);
        this.tb.markO(2, 2);
        TicTacToeTest.assertEquals((boolean)true, (boolean)this.tb.isAnyColumnComplete());
        this.tb.markX(2, 2);
        this.tb.markX(1, 1);
        TicTacToeTest.assertEquals((boolean)true, (boolean)this.tb.isAnyDiagonalComplete());
        this.tb.markO(1, 1);
        this.tb.markO(2, 0);
        TicTacToeTest.assertEquals((boolean)true, (boolean)this.tb.isAnyDiagonalComplete());
    }

    public void testGivenABoardNUmberOfPossibleMovesCalculatedCorrectly() {
        TicTacToe ticTacToe = new TicTacToe();
        TicTacToeTest.assertEquals((int)9, (int)ticTacToe.getMoves(ticTacToe.getState()).size());
        TicTacToeTest.assertEquals((String)"X", (String)ticTacToe.getPlayerToMove(ticTacToe.getState()));
        ticTacToe.makeMove(ticTacToe.getState(), 0, 0);
        TicTacToeTest.assertEquals((int)8, (int)ticTacToe.getMoves(ticTacToe.getState()).size());
        TicTacToeTest.assertEquals((String)"O", (String)ticTacToe.getPlayerToMove(ticTacToe.getState()));
        ticTacToe.makeMove(ticTacToe.getState(), 0, 0);
        TicTacToeTest.assertEquals((int)8, (int)ticTacToe.getMoves(ticTacToe.getState()).size());
        TicTacToeTest.assertEquals((String)"O", (String)ticTacToe.getPlayerToMove(ticTacToe.getState()));
        ticTacToe.makeMove(ticTacToe.getState(), 1, 1);
        TicTacToeTest.assertEquals((int)7, (int)ticTacToe.getMoves(ticTacToe.getState()).size());
        TicTacToeTest.assertEquals((String)"X", (String)ticTacToe.getPlayerToMove(ticTacToe.getState()));
    }

    public void testCalculateUtilityOfABoard() {
        TicTacToe ticTacToe = new TicTacToe();
        ticTacToe.makeMove(ticTacToe.getState(), 0, 0);
        TicTacToeTest.assertEquals((int)0, (int)ticTacToe.getUtility(ticTacToe.getState()));
        ticTacToe.makeMove(ticTacToe.getState(), 2, 2);
        TicTacToeTest.assertEquals((int)0, (int)ticTacToe.getUtility(ticTacToe.getState()));
        ticTacToe.makeMove(ticTacToe.getState(), 2, 0);
        TicTacToeTest.assertEquals((int)0, (int)ticTacToe.getUtility(ticTacToe.getState()));
        ticTacToe.makeMove(ticTacToe.getState(), 1, 0);
        TicTacToeTest.assertEquals((int)0, (int)ticTacToe.getUtility(ticTacToe.getState()));
        ticTacToe.makeMove(ticTacToe.getState(), 0, 2);
        TicTacToeTest.assertEquals((int)0, (int)ticTacToe.getUtility(ticTacToe.getState()));
        ticTacToe.makeMove(ticTacToe.getState(), 0, 1);
        TicTacToeTest.assertEquals((int)0, (int)ticTacToe.getUtility(ticTacToe.getState()));
        ticTacToe.makeMove(ticTacToe.getState(), 1, 1);
        TicTacToeTest.assertEquals((int)1, (int)ticTacToe.computeUtility(ticTacToe.getState()));
        TicTacToe ticTacToe2 = new TicTacToe();
        ticTacToe2.makeMove(ticTacToe2.getState(), 0, 0);
        TicTacToeTest.assertEquals((int)0, (int)ticTacToe2.getUtility(ticTacToe2.getState()));
        ticTacToe2.makeMove(ticTacToe2.getState(), 0, 1);
        TicTacToeTest.assertEquals((int)0, (int)ticTacToe2.getUtility(ticTacToe2.getState()));
        ticTacToe2.makeMove(ticTacToe2.getState(), 0, 2);
        TicTacToeTest.assertEquals((int)0, (int)ticTacToe2.getUtility(ticTacToe2.getState()));
        ticTacToe2.makeMove(ticTacToe2.getState(), 1, 0);
        TicTacToeTest.assertEquals((int)0, (int)ticTacToe2.getUtility(ticTacToe2.getState()));
        ticTacToe2.makeMove(ticTacToe2.getState(), 1, 1);
        TicTacToeTest.assertEquals((int)0, (int)ticTacToe2.getUtility(ticTacToe2.getState()));
        ticTacToe2.makeMove(ticTacToe2.getState(), 1, 2);
        TicTacToeTest.assertEquals((int)0, (int)ticTacToe2.getUtility(ticTacToe2.getState()));
        ticTacToe2.makeMove(ticTacToe2.getState(), 2, 0);
        TicTacToeTest.assertEquals((int)1, (int)ticTacToe2.computeUtility(ticTacToe2.getState()));
    }

    public void testGenerateSuccessors() {
        TicTacToe ticTacToe = new TicTacToe();
        ArrayList arrayList = ticTacToe.getSuccessorStates(ticTacToe.getState());
        TicTacToeTest.assertEquals((int)9, (int)arrayList.size());
        this.checkSuccessorList(arrayList, "O", 8);
        ArrayList arrayList2 = ticTacToe.getSuccessorStates((GameState)arrayList.get(0));
        this.checkSuccessorList(arrayList2, "X", 7);
        ArrayList arrayList3 = ticTacToe.getSuccessorStates((GameState)arrayList2.get(0));
        this.checkSuccessorList(arrayList3, "O", 6);
    }

    public void testGameStateEquality() {
        TicTacToeBoard ticTacToeBoard = new TicTacToeBoard();
        TicTacToeBoard ticTacToeBoard2 = new TicTacToeBoard();
        GameState gameState = new GameState();
        GameState gameState2 = new GameState();
        gameState.put("board", ticTacToeBoard);
        gameState2.put("board", ticTacToeBoard2);
        TicTacToeTest.assertEquals((Object)gameState, (Object)gameState2);
        gameState.put("minimaxValue", new Integer(3));
        TicTacToeTest.assertTrue((!gameState.equals(gameState2) ? 1 : 0) != 0);
    }

    public void testMiniMax() {
        TicTacToe ticTacToe = new TicTacToe();
        ticTacToe.makeMove(0, 0);
        ticTacToe.makeMove(2, 2);
        ticTacToe.makeMove(2, 0);
        ticTacToe.makeMove(1, 1);
        TicTacToeTest.assertEquals((int)1, (int)ticTacToe.getMiniMaxValue(ticTacToe.getState()));
    }

    public void testMiniMax2() {
        TicTacToe ticTacToe = new TicTacToe();
        ticTacToe.makeMove(0, 0);
        ticTacToe.makeMove(2, 2);
        ticTacToe.makeMove(2, 0);
        TicTacToeTest.assertEquals((int)1, (int)ticTacToe.getMiniMaxValue(ticTacToe.getState()));
    }

    public void testMiniMax3() {
        TicTacToe ticTacToe = new TicTacToe();
        ticTacToe.makeMove(0, 0);
        ticTacToe.makeMove(1, 1);
        TicTacToeTest.assertEquals((int)0, (int)ticTacToe.getMiniMaxValue(ticTacToe.getState()));
    }

    public void testMiniMax7() {
        TicTacToe ticTacToe = new TicTacToe();
        ticTacToe.makeMove(0, 0);
        ticTacToe.makeMove(0, 1);
        TicTacToeTest.assertEquals((int)1, (int)ticTacToe.getMiniMaxValue(ticTacToe.getState()));
    }

    public void tesMiniMax4() {
        TicTacToe ticTacToe = new TicTacToe();
        TicTacToeTest.assertEquals((int)0, (int)ticTacToe.getMiniMaxValue(ticTacToe.getState()));
    }

    public void testTerminalStateDetection() {
        TicTacToe ticTacToe = new TicTacToe();
        ticTacToe.makeMove(0, 0);
        ticTacToe.makeMove(0, 1);
        ticTacToe.makeMove(0, 2);
        ticTacToe.makeMove(1, 0);
        ticTacToe.makeMove(1, 1);
        ticTacToe.makeMove(1, 2);
        TicTacToeTest.assertEquals((int)1, (int)ticTacToe.getMiniMaxValue(ticTacToe.getState()));
    }

    public void testMiniMax15() {
        TicTacToe ticTacToe = new TicTacToe();
        ticTacToe.makeMove(0, 0);
        int n = ticTacToe.getMiniMaxValue(ticTacToe.getState());
        TicTacToe ticTacToe2 = new TicTacToe();
        ticTacToe2.makeMove(0, 2);
        int n2 = ticTacToe2.getMiniMaxValue(ticTacToe2.getState());
        TicTacToe ticTacToe3 = new TicTacToe();
        ticTacToe3.makeMove(2, 0);
        int n3 = ticTacToe3.getMiniMaxValue(ticTacToe3.getState());
        TicTacToe ticTacToe4 = new TicTacToe();
        int n4 = ticTacToe4.getMiniMaxValue(ticTacToe4.getState());
        ticTacToe4.makeMove(2, 2);
        TicTacToeTest.assertEquals((int)n, (int)n2);
    }

    public void testMiniMax6() {
        TicTacToe ticTacToe = new TicTacToe();
        ticTacToe.makeMove(0, 0);
        ticTacToe.makeMove(0, 1);
        ticTacToe.makeMove(0, 2);
        ticTacToe.makeMove(2, 2);
        ticTacToe.makeMove(1, 2);
        ticTacToe.makeMove(2, 1);
        ticTacToe.makeMove(1, 1);
        TicTacToeTest.assertEquals((int)-1, (int)ticTacToe.getMiniMaxValue(ticTacToe.getState()));
    }

    public void testAlphaBeta() {
        TicTacToe ticTacToe = new TicTacToe();
        int n = ticTacToe.getAlphaBetaValue(ticTacToe.getState());
        TicTacToeTest.assertEquals((int)0, (int)n);
        ticTacToe.makeMove(0, 0);
        int n2 = ticTacToe.getAlphaBetaValue(ticTacToe.getState());
        TicTacToeTest.assertEquals((int)0, (int)n2);
        TicTacToe ticTacToe2 = new TicTacToe();
        ticTacToe2.makeMove(0, 2);
        int n3 = ticTacToe2.getAlphaBetaValue(ticTacToe2.getState());
        TicTacToeTest.assertEquals((int)0, (int)n3);
        TicTacToe ticTacToe3 = new TicTacToe();
        ticTacToe3.makeMove(2, 0);
        int n4 = ticTacToe3.getAlphaBetaValue(ticTacToe3.getState());
        TicTacToeTest.assertEquals((int)0, (int)n4);
        TicTacToe ticTacToe4 = new TicTacToe();
        int n5 = ticTacToe4.getAlphaBetaValue(ticTacToe4.getState());
        ticTacToe4.makeMove(2, 2);
        TicTacToeTest.assertEquals((int)0, (int)n5);
    }

    private void checkSuccessorList(ArrayList arrayList, String string, int n) {
        for (int i = 0; i < arrayList.size(); ++i) {
            GameState gameState = (GameState)arrayList.get(i);
            ArrayList arrayList2 = new TicTacToe().getSuccessorStates(gameState);
            TicTacToeTest.assertEquals((int)n, (int)arrayList2.size());
            TicTacToeTest.assertEquals((String)string, (String)new TicTacToe().getPlayerToMove(gameState));
        }
    }

    public void testAlphaBetaMinValueCalculation() {
        TicTacToe ticTacToe = new TicTacToe();
        ticTacToe.makeMove(0, 0);
        ticTacToe.makeMove(0, 1);
        ticTacToe.makeMove(0, 2);
        ticTacToe.makeMove(1, 0);
        ticTacToe.makeMove(1, 2);
        ticTacToe.makeMove(1, 1);
        ticTacToe.makeMove(2, 1);
        int n = ticTacToe.minValue(ticTacToe.getState(), new AlphaBeta(Integer.MIN_VALUE, Integer.MAX_VALUE));
        TicTacToeTest.assertEquals((int)0, (int)n);
    }
}

