/*
 * Decompiled with CFR 0.152.
 */
package aima.search.uninformed;

import aima.search.framework.BidirectionalProblem;
import aima.search.framework.GraphSearch;
import aima.search.framework.Metrics;
import aima.search.framework.Node;
import aima.search.framework.Problem;
import aima.search.framework.Search;
import aima.search.framework.SearchUtils;
import aima.search.framework.Successor;
import aima.search.nodestore.CachedStateNodeStore;
import aima.search.nodestore.FIFONodeStore;
import java.util.ArrayList;
import java.util.List;

public class BidirectionalSearch
implements Search {
    protected Metrics metrics;
    private SearchOutcome searchOutcome = SearchOutcome.PATH_NOT_FOUND;
    private static final String NODES_EXPANDED = "nodesExpanded";
    private static final String QUEUE_SIZE = "queueSize";
    private static final String MAX_QUEUE_SIZE = "maxQueueSize";
    private static final String PATH_COST = "pathCost";

    public BidirectionalSearch() {
        this.metrics = new Metrics();
    }

    @Override
    public List<String> search(Problem problem) throws Exception {
        assert (problem instanceof BidirectionalProblem);
        this.searchOutcome = SearchOutcome.PATH_NOT_FOUND;
        this.clearInstrumentation();
        Problem problem2 = ((BidirectionalProblem)((Object)problem)).getOriginalProblem();
        Problem problem3 = ((BidirectionalProblem)((Object)problem)).getReverseProblem();
        CachedStateNodeStore cachedStateNodeStore = new CachedStateNodeStore(new FIFONodeStore());
        CachedStateNodeStore cachedStateNodeStore2 = new CachedStateNodeStore(new FIFONodeStore());
        GraphSearch graphSearch = new GraphSearch();
        GraphSearch graphSearch2 = new GraphSearch();
        graphSearch.clearInstrumentation();
        graphSearch2.clearInstrumentation();
        Node node = new Node(problem2.getInitialState());
        Node node2 = new Node(problem3.getInitialState());
        cachedStateNodeStore.add(node);
        cachedStateNodeStore2.add(node2);
        this.setQueueSize(cachedStateNodeStore.size() + cachedStateNodeStore2.size());
        this.setNodesExpanded(graphSearch.getNodesExpanded() + graphSearch2.getNodesExpanded());
        while (!cachedStateNodeStore.isEmpty() || !cachedStateNodeStore2.isEmpty()) {
            Object object;
            if (!cachedStateNodeStore.isEmpty()) {
                node = cachedStateNodeStore.remove();
                graphSearch.addExpandedNodesToFringe(cachedStateNodeStore, node, problem2);
            } else {
                node = null;
            }
            if (!cachedStateNodeStore2.isEmpty()) {
                node2 = cachedStateNodeStore2.remove();
                graphSearch2.addExpandedNodesToFringe(cachedStateNodeStore2, node2, problem3);
            } else {
                node2 = null;
            }
            this.setQueueSize(cachedStateNodeStore.size() + cachedStateNodeStore2.size());
            this.setNodesExpanded(graphSearch.getNodesExpanded() + graphSearch2.getNodesExpanded());
            if (null != node && null != node2) {
                List<String> list;
                object = null;
                Node node3 = null;
                if (cachedStateNodeStore.containsNodeBasedOn(node2.getState())) {
                    object = cachedStateNodeStore.getNodeBasedOn(node2.getState());
                    node3 = node2;
                } else if (cachedStateNodeStore2.containsNodeBasedOn(node.getState())) {
                    object = node;
                    node3 = cachedStateNodeStore2.getNodeBasedOn(node.getState());
                } else if (node.getState().equals(node2.getState())) {
                    object = node;
                    node3 = node2;
                }
                if (null != object && null != node3 && null != (list = this.retrieveActions(problem2, problem3, (Node)object, node3))) {
                    return list;
                }
            }
            if (null != node && problem2.isGoalState(node.getState())) {
                return this.retrieveActions(problem2, problem3, node, null);
            }
            if (null == node2 || !problem3.isGoalState(node2.getState()) || null == (object = this.retrieveActions(problem2, problem3, null, node2))) continue;
            return object;
        }
        return new ArrayList<String>();
    }

    public SearchOutcome getSearchOutcome() {
        return this.searchOutcome;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    public void clearInstrumentation() {
        this.metrics.set(NODES_EXPANDED, 0);
        this.metrics.set(QUEUE_SIZE, 0);
        this.metrics.set(MAX_QUEUE_SIZE, 0);
        this.metrics.set(PATH_COST, 0.0);
    }

    public int getNodesExpanded() {
        return this.metrics.getInt(NODES_EXPANDED);
    }

    public void setNodesExpanded(int n) {
        this.metrics.set(NODES_EXPANDED, n);
    }

    public int getQueueSize() {
        return this.metrics.getInt(QUEUE_SIZE);
    }

    public void setQueueSize(int n) {
        this.metrics.set(QUEUE_SIZE, n);
        int n2 = this.metrics.getInt(MAX_QUEUE_SIZE);
        if (n > n2) {
            this.metrics.set(MAX_QUEUE_SIZE, n);
        }
    }

    public int getMaxQueueSize() {
        return this.metrics.getInt(MAX_QUEUE_SIZE);
    }

    public double getPathCost() {
        return this.metrics.getDouble(PATH_COST);
    }

    public void setPathCost(Double d) {
        this.metrics.set(PATH_COST, d);
    }

    private List<String> retrieveActions(Problem problem, Problem problem2, Node node, Node node2) {
        ArrayList<String> arrayList = new ArrayList();
        if (null == node2) {
            this.setPathCost(node.getPathCost());
            this.searchOutcome = SearchOutcome.PATH_FOUND_FROM_ORIGINAL_PROBLEM;
            arrayList = SearchUtils.actionsFromNodes(node.getPathFromRoot());
        } else {
            ArrayList<Node> arrayList2 = new ArrayList<Node>();
            Object object = null;
            if (null != node) {
                arrayList2.addAll(node.getPathFromRoot());
                object = node.getState();
            }
            if (!problem.isGoalState(node2.getState())) {
                List<Node> list = node2.getPathFromRoot();
                for (int i = list.size() - 1; i >= 0; --i) {
                    if (list.get(i).getState().equals(object)) continue;
                    arrayList2.add(list.get(i));
                }
            }
            if (!this.canTraversePathFromOriginalProblem(problem, arrayList2, arrayList)) {
                return null;
            }
            this.searchOutcome = null == node ? SearchOutcome.PATH_FOUND_FROM_REVERSE_PROBLEM : (this.canConnectToOriginalFromReverse(problem2, node, node2) ? SearchOutcome.PATH_FOUND_BETWEEN_PROBLEMS : SearchOutcome.PATH_FOUND_FROM_ORIGINAL_PROBLEM);
        }
        return arrayList;
    }

    private boolean canTraversePathFromOriginalProblem(Problem problem, List<Node> list, List<String> list2) {
        boolean bl = true;
        double d = 0.0;
        for (int i = 0; i < list.size() - 1; ++i) {
            Object object = list.get(i).getState();
            Object object2 = list.get(i + 1).getState();
            List list3 = problem.getSuccessorFunction().getSuccessors(object);
            boolean bl2 = false;
            for (Successor successor : list3) {
                if (!object2.equals(successor.getState())) continue;
                bl2 = true;
                d += problem.getStepCostFunction().calculateStepCost(object, object2, successor.getAction()).doubleValue();
                list2.add(successor.getAction());
                break;
            }
            if (bl2) continue;
            bl = false;
            break;
        }
        this.setPathCost(true == bl ? d : 0.0);
        return bl;
    }

    private boolean canConnectToOriginalFromReverse(Problem problem, Node node, Node node2) {
        boolean bl = true;
        if (!node.isRootNode()) {
            bl = false;
            List list = problem.getSuccessorFunction().getSuccessors(node2.getState());
            for (Successor successor : list) {
                if (!node.getParent().getState().equals(successor.getState())) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static enum SearchOutcome {
        PATH_FOUND_FROM_ORIGINAL_PROBLEM,
        PATH_FOUND_FROM_REVERSE_PROBLEM,
        PATH_FOUND_BETWEEN_PROBLEMS,
        PATH_NOT_FOUND;

    }
}

